/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llms.recording;

import cc.unitmesh.devti.llms.recording.Recording;
import cc.unitmesh.devti.llms.recording.RecordingInstruction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcc/unitmesh/devti/llms/recording/JsonlRecording;", "Lcc/unitmesh/devti/llms/recording/Recording;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "recordingPath", "Ljava/nio/file/Path;", "write", "", "instruction", "Lcc/unitmesh/devti/llms/recording/RecordingInstruction;", "core"})
@SourceDebugExtension(value={"SMAP\nJsonlRecording.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonlRecording.kt\ncc/unitmesh/devti/llms/recording/JsonlRecording\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,22:1\n205#2:23\n*S KotlinDebug\n*F\n+ 1 JsonlRecording.kt\ncc/unitmesh/devti/llms/recording/JsonlRecording\n*L\n18#1:23\n*E\n"})
public final class JsonlRecording
implements Recording {
    @NotNull
    private final Project project;
    @NotNull
    private final Path recordingPath;

    public JsonlRecording(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        String[] stringArray = new String[]{"recording.jsonl"};
        Path path = Path.of(virtualFile.getPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        this.recordingPath = path;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void write(@NotNull RecordingInstruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (!this.recordingPath.toFile().exists()) {
            this.recordingPath.toFile().createNewFile();
        }
        File file = this.recordingPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        FilesKt.appendText$default((File)file, (String)(this_$iv.encodeToString((SerializationStrategy)RecordingInstruction.Companion.serializer(), (Object)instruction) + "\n"), null, (int)2, null);
    }
}

