/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llms.custom;

import cc.unitmesh.devti.llms.custom.AutoDevHttpException;
import cc.unitmesh.devti.llms.custom.SSE;
import com.intellij.openapi.diagnostic.Logger;
import io.reactivex.rxjava3.core.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/llms/custom/ResponseBodyCallback;", "Lokhttp3/Callback;", "emitter", "Lio/reactivex/rxjava3/core/FlowableEmitter;", "Lcc/unitmesh/devti/llms/custom/SSE;", "emitDone", "", "<init>", "(Lio/reactivex/rxjava3/core/FlowableEmitter;Z)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "onResponse", "", "call", "Lokhttp3/Call;", "response", "Lokhttp3/Response;", "onFailure", "e", "Ljava/io/IOException;", "core"})
@SourceDebugExtension(value={"SMAP\nResponseBodyCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseBodyCallback.kt\ncc/unitmesh/devti/llms/custom/ResponseBodyCallback\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,144:1\n11#2:145\n11#2:193\n11#2:194\n1#3:146\n107#4:147\n79#4,22:148\n107#4:170\n79#4,22:171\n*S KotlinDebug\n*F\n+ 1 ResponseBodyCallback.kt\ncc/unitmesh/devti/llms/custom/ResponseBodyCallback\n*L\n46#1:145\n126#1:193\n127#1:194\n65#1:147\n65#1:148,22\n82#1:170\n82#1:171,22\n*E\n"})
public final class ResponseBodyCallback
implements Callback {
    @NotNull
    private final FlowableEmitter<SSE> emitter;
    private final boolean emitDone;
    @NotNull
    private final Logger logger;

    public ResponseBodyCallback(@NotNull FlowableEmitter<SSE> emitter, boolean emitDone) {
        Intrinsics.checkNotNullParameter(emitter, (String)"emitter");
        this.emitter = emitter;
        this.emitDone = emitDone;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ResponseBodyCallback.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onResponse(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        BufferedReader reader = null;
        try {
            if (!response.isSuccessful()) {
                if (response.body() == null) {
                    throw new AutoDevHttpException("Response body is null", response.code());
                }
                Object object = response.body();
                if (object != null) {
                    String string;
                    String string2 = string = object.string();
                    object = string2;
                    if (string2 != null) throw new AutoDevHttpException((String)object, response.code());
                }
                object = "";
                throw new AutoDevHttpException((String)object, response.code());
            }
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            InputStream inputStream = responseBody.byteStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            Ref.ObjectRef line = new Ref.ObjectRef();
            SSE sse = null;
            while (!this.emitter.isCancelled()) {
                block38: {
                    block39: {
                        SSE sSE;
                        block32: {
                            String eventName;
                            boolean match$iv$iv;
                            char it;
                            int index$iv$iv;
                            boolean startFound$iv$iv;
                            int endIndex$iv$iv;
                            int startIndex$iv$iv;
                            CharSequence $this$trim$iv$iv;
                            block34: {
                                block30: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block33: {
                                                    boolean $i$f$trim;
                                                    String $this$trim$iv;
                                                    boolean $i$f$trim2;
                                                    block31: {
                                                        block29: {
                                                            String string;
                                                            String it2 = string = reader.readLine();
                                                            boolean bl = false;
                                                            line.element = it2;
                                                            if (string == null) break;
                                                            Object object = line.element;
                                                            Intrinsics.checkNotNull((Object)object);
                                                            if (!StringsKt.startsWith$default((String)((String)object), (String)"data:", (boolean)false, (int)2, null)) break block29;
                                                            Object object2 = line.element;
                                                            Intrinsics.checkNotNull((Object)object2);
                                                            String string3 = ((String)object2).substring(5);
                                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                                            it2 = string3;
                                                            $i$f$trim2 = false;
                                                            $this$trim$iv$iv = $this$trim$iv;
                                                            $i$f$trim = false;
                                                            startIndex$iv$iv = 0;
                                                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                                            startFound$iv$iv = false;
                                                            break block30;
                                                        }
                                                        if (!Intrinsics.areEqual((Object)line.element, (Object)"") || sse == null) break block31;
                                                        if (sse.isDone()) {
                                                            if (!this.emitDone) break;
                                                            this.emitter.onNext((Object)sse);
                                                            break;
                                                        }
                                                        this.emitter.onNext((Object)sse);
                                                        sSE = null;
                                                        break block32;
                                                    }
                                                    Object object = line.element;
                                                    Intrinsics.checkNotNull((Object)object);
                                                    if (!StringsKt.startsWith$default((String)((String)object), (String)"event:", (boolean)false, (int)2, null)) break block33;
                                                    Object object3 = line.element;
                                                    Intrinsics.checkNotNull((Object)object3);
                                                    Intrinsics.checkNotNullExpressionValue((Object)((String)object3).substring(6), (String)"substring(...)");
                                                    $i$f$trim2 = false;
                                                    $this$trim$iv$iv = $this$trim$iv;
                                                    $i$f$trim = false;
                                                    startIndex$iv$iv = 0;
                                                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                                    startFound$iv$iv = false;
                                                    break block34;
                                                }
                                                Object object = line.element;
                                                Intrinsics.checkNotNull((Object)object);
                                                if (!StringsKt.startsWith$default((String)((String)object), (String)": ping", (boolean)false, (int)2, null)) break block35;
                                                sSE = null;
                                                break block32;
                                            }
                                            if (!Intrinsics.areEqual((Object)line.element, (Object)"")) break block36;
                                            sSE = null;
                                            break block32;
                                        }
                                        Object object = line.element;
                                        Intrinsics.checkNotNull((Object)object);
                                        if (!StringsKt.startsWith$default((String)((String)object), (String)":", (boolean)false, (int)2, null)) break block37;
                                        sSE = null;
                                        break block32;
                                    }
                                    if (!StringsKt.startsWith$default((String)((String)line.element), (String)"{", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)((String)line.element), (String)"}", (boolean)false, (int)2, null)) break block38;
                                    break block39;
                                }
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                String data = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                sSE = new SSE(data);
                                break block32;
                            }
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if (Intrinsics.areEqual((Object)(eventName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (Object)"ping")) {
                                SSE sSE2 = sse;
                                if (sSE2 == null) {
                                    sSE2 = new SSE("");
                                }
                                this.emitter.onNext((Object)sSE2);
                                SSE sSE3 = sse;
                                if (sSE3 == null) {
                                    sSE3 = new SSE("");
                                }
                                this.emitter.onNext((Object)sSE3);
                            }
                            sSE = null;
                        }
                        sse = sSE;
                        continue;
                    }
                    this.emitter.onNext((Object)new SSE((String)line.element));
                    this.emitter.onComplete();
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                throw new AutoDevHttpException("Invalid sse format! '" + line.element + "'", response.code());
            }
        }
        catch (Throwable t) {
            try {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ResponseBodyCallback.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Error while reading SSE", t);
                $i$f$logger = false;
                Logger logger2 = Logger.getInstance(ResponseBodyCallback.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.error("Request: " + call.request());
                this.onFailure(call, new IOException(t));
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.emitter.onComplete();
        try {
            reader.close();
            return;
        }
        catch (IOException inputStream) {
            return;
        }
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.emitter.onError((Throwable)e);
    }
}

