/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llms.custom;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.gui.chat.message.ChatRole;
import cc.unitmesh.devti.llm2.model.LlmConfig;
import cc.unitmesh.devti.llm2.model.ModelType;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.custom.CustomRequest;
import cc.unitmesh.devti.llms.custom.CustomRequestKt;
import cc.unitmesh.devti.llms.custom.CustomSSEProcessor;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.observer.agent.AgentStateService;
import cc.unitmesh.devti.prompting.optimizer.PromptOptimizer;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020 0(H\u0016J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,H\u0016J.\u00100\u001a\b\u0012\u0004\u0012\u00020\u0010012\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0016J\u0014\u00107\u001a\u00020\u0006*\u00020\u00002\u0006\u00103\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n \u001d*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\f\"\u0004\b/\u0010\u000e\u00a8\u00068"}, d2={"Lcc/unitmesh/devti/llms/custom/CustomLLMProvider;", "Lcc/unitmesh/devti/llms/LLMProvider;", "Lcc/unitmesh/devti/llms/custom/CustomSSEProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "llmConfig", "Lcc/unitmesh/devti/llm2/model/LlmConfig;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/llm2/model/LlmConfig;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLlmConfig", "()Lcc/unitmesh/devti/llm2/model/LlmConfig;", "setLlmConfig", "(Lcc/unitmesh/devti/llm2/model/LlmConfig;)V", "url", "", "getUrl", "()Ljava/lang/String;", "key", "getKey", "requestFormat", "getRequestFormat", "responseFormat", "getResponseFormat", "client", "Lokhttp3/OkHttpClient;", "timeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "messages", "", "Lcc/unitmesh/devti/llms/custom/Message;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "agentService", "Lcc/unitmesh/devti/observer/agent/AgentStateService;", "clearMessage", "", "getAllMessages", "", "appendLocalMessage", "msg", "role", "Lcc/unitmesh/devti/gui/chat/message/ChatRole;", "backupLlmConfigForPlan", "getBackupLlmConfigForPlan", "setBackupLlmConfigForPlan", "stream", "Lkotlinx/coroutines/flow/Flow;", "promptText", "systemPrompt", "keepHistory", "", "usePlanForFirst", "tryUpdateModelForPlan", "core"})
@SourceDebugExtension(value={"SMAP\nCustomLLMProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomLLMProvider.kt\ncc/unitmesh/devti/llms/custom/CustomLLMProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n11#2:140\n*S KotlinDebug\n*F\n+ 1 CustomLLMProvider.kt\ncc/unitmesh/devti/llms/custom/CustomLLMProvider\n*L\n37#1:140\n*E\n"})
public final class CustomLLMProvider
extends CustomSSEProcessor
implements LLMProvider {
    @NotNull
    private final Project project;
    @NotNull
    private LlmConfig llmConfig;
    @NotNull
    private OkHttpClient client;
    private final Duration timeout;
    @NotNull
    private final List<Message> messages;
    @NotNull
    private final Logger logger;
    private final AgentStateService agentService;
    @NotNull
    private LlmConfig backupLlmConfigForPlan;

    public CustomLLMProvider(@NotNull Project project, @NotNull LlmConfig llmConfig) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)llmConfig, (String)"llmConfig");
        super(project);
        this.project = project;
        this.llmConfig = llmConfig;
        this.client = new OkHttpClient();
        this.timeout = Duration.ofSeconds(this.getDefaultTimeout());
        this.messages = new ArrayList();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CustomLLMProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.agentService = (AgentStateService)this.project.getService(AgentStateService.class);
        this.backupLlmConfigForPlan = this.llmConfig;
    }

    public /* synthetic */ CustomLLMProvider(Project project, LlmConfig llmConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            llmConfig = LlmConfig.Companion.default();
        }
        this(project, llmConfig);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LlmConfig getLlmConfig() {
        return this.llmConfig;
    }

    public final void setLlmConfig(@NotNull LlmConfig llmConfig) {
        Intrinsics.checkNotNullParameter((Object)llmConfig, (String)"<set-?>");
        this.llmConfig = llmConfig;
    }

    private final String getUrl() {
        return this.llmConfig.getUrl();
    }

    private final String getKey() {
        return this.llmConfig.getAuth().getToken();
    }

    @Override
    @NotNull
    public String getRequestFormat() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.llmConfig.getRequestFormat();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.llmConfig.toLegacyRequestFormat();
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Override
    @NotNull
    public String getResponseFormat() {
        return this.llmConfig.getResponseFormat();
    }

    @Override
    public void clearMessage() {
        this.messages.clear();
    }

    @Override
    @NotNull
    public List<Message> getAllMessages() {
        return this.messages;
    }

    @Override
    public void appendLocalMessage(@NotNull String msg2, @NotNull ChatRole role) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        if (((CharSequence)msg2).length() == 0) {
            return;
        }
        ((Collection)this.messages).add(new Message(role.roleName(), msg2));
    }

    @NotNull
    public final LlmConfig getBackupLlmConfigForPlan() {
        return this.backupLlmConfigForPlan;
    }

    public final void setBackupLlmConfigForPlan(@NotNull LlmConfig llmConfig) {
        Intrinsics.checkNotNullParameter((Object)llmConfig, (String)"<set-?>");
        this.backupLlmConfigForPlan = llmConfig;
    }

    @Override
    @NotNull
    public Flow<String> stream(@NotNull String promptText2, @NotNull String systemPrompt, boolean keepHistory, boolean usePlanForFirst) {
        Call call;
        Intrinsics.checkNotNullParameter((Object)promptText2, (String)"promptText");
        Intrinsics.checkNotNullParameter((Object)systemPrompt, (String)"systemPrompt");
        this.llmConfig = usePlanForFirst ? this.tryUpdateModelForPlan(this, systemPrompt) : this.backupLlmConfigForPlan;
        this.logger.info("Requesting to model: " + this.llmConfig.getName() + ", " + this.getUrl());
        if (!keepHistory || ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getNoChatHistory()) {
            this.clearMessage();
        }
        if (((CharSequence)systemPrompt).length() > 0) {
            if (!((Collection)this.messages).isEmpty() && !Intrinsics.areEqual((Object)this.messages.get(0).getRole(), (Object)"system")) {
                this.messages.add(0, new Message("system", systemPrompt));
            } else if (this.messages.isEmpty()) {
                this.messages.add(new Message("system", systemPrompt));
            } else {
                this.messages.set(0, new Message("system", systemPrompt));
            }
        }
        String prompt2 = ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getTrimCodeBeforeSend() ? PromptOptimizer.INSTANCE.trimCodeSpace(promptText2) : promptText2;
        ((Collection)this.messages).add(new Message("user", prompt2));
        List<Message> finalMsgs = this.agentService.processMessages(this.messages);
        CustomRequest customRequest = new CustomRequest(finalMsgs);
        String requestContent = CustomRequestKt.updateCustomFormat(customRequest, this.getRequestFormat());
        MediaType mediaType = MediaType.Companion.parse("application/json");
        String string = requestContent;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        RequestBody body = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)mediaType, (byte[])byArray, (int)0, (int)0, (int)12, null);
        Request.Builder builder = new Request.Builder();
        if (((CharSequence)this.getKey()).length() > 0) {
            builder.addHeader("Authorization", "Bearer " + this.getKey());
            builder.addHeader("Content-Type", "application/json");
        }
        CustomRequestKt.appendCustomHeaders(builder, this.getRequestFormat());
        this.logger.info("Requesting form: " + requestContent + " " + body);
        OkHttpClient.Builder builder2 = this.client.newBuilder();
        Duration duration = this.timeout;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"timeout");
        this.client = builder2.readTimeout(duration).build();
        try {
            call = this.client.newCall(builder.url(this.getUrl()).post(body).build());
        }
        catch (IllegalArgumentException e) {
            String string2 = e.getMessage();
            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Expected URL scheme", (boolean)false, (int)2, null) : false;
            if (bl) {
                AutoDevNotifications.INSTANCE.error(this.project, AutoDevBundle.message("llm.error.url.scheme", new Object[0]));
            }
            throw e;
        }
        Call call2 = call;
        if (!keepHistory || ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getNoChatHistory()) {
            this.clearMessage();
        }
        return this.streamSSE(call2, prompt2, keepHistory, this.messages);
    }

    private final LlmConfig tryUpdateModelForPlan(CustomLLMProvider $this$tryUpdateModelForPlan, String systemPrompt) {
        LlmConfig llmConfig;
        int canBePlanLength = 3;
        if ($this$tryUpdateModelForPlan.messages.size() == canBePlanLength) {
            $this$tryUpdateModelForPlan.messages.set(0, new Message("system", systemPrompt));
        }
        if ($this$tryUpdateModelForPlan.messages.size() == canBePlanLength && LlmConfig.Companion.hasPlanModel()) {
            $this$tryUpdateModelForPlan.backupLlmConfigForPlan = $this$tryUpdateModelForPlan.llmConfig;
            llmConfig = (LlmConfig)CollectionsKt.first(LlmConfig.Companion.load(ModelType.Plan));
        } else {
            llmConfig = $this$tryUpdateModelForPlan.backupLlmConfigForPlan;
        }
        return llmConfig;
    }

    @Override
    public long getDefaultTimeout() {
        return LLMProvider.DefaultImpls.getDefaultTimeout(this);
    }
}

