/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llms;

import cc.unitmesh.devti.llm2.model.LlmConfig;
import cc.unitmesh.devti.llm2.model.ModelType;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LLMProviderAdapter;
import cc.unitmesh.devti.llms.custom.CustomLLMProvider;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lcc/unitmesh/devti/llms/LlmFactory;", "", "<init>", "()V", "create", "Lcc/unitmesh/devti/llms/LLMProvider;", "project", "Lcom/intellij/openapi/project/Project;", "modelType", "Lcc/unitmesh/devti/llm2/model/ModelType;", "createCompletion", "createLegacy", "core"})
public final class LlmFactory {
    @NotNull
    public static final LlmFactory INSTANCE = new LlmFactory();

    private LlmFactory() {
    }

    @NotNull
    public final LLMProvider create(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new LLMProviderAdapter(project, null, 2, null);
    }

    @NotNull
    public final LLMProvider create(@NotNull Project project, @NotNull ModelType modelType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)modelType), (String)"modelType");
        return new LLMProviderAdapter(project, modelType);
    }

    @NotNull
    public final LLMProvider createCompletion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new LLMProviderAdapter(project, ModelType.Completion);
    }

    @Deprecated(message="Use create() instead", replaceWith=@ReplaceWith(expression="create(project)", imports={}))
    @NotNull
    public final LLMProvider createLegacy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new CustomLLMProvider(project, null, 2, null);
    }

    @Deprecated(message="Use create(project, modelType) instead", replaceWith=@ReplaceWith(expression="create(project, modelType)", imports={}))
    @NotNull
    public final LLMProvider createLegacy(@NotNull Project project, @NotNull ModelType modelType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)modelType), (String)"modelType");
        List<LlmConfig> llmConfigs = LlmConfig.Companion.load(modelType);
        LlmConfig llmConfig = (LlmConfig)CollectionsKt.firstOrNull(llmConfigs);
        if (llmConfig == null) {
            llmConfig = LlmConfig.Companion.default();
        }
        LlmConfig llmConfig2 = llmConfig;
        return new CustomLLMProvider(project, llmConfig2);
    }
}

