/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llm2;

import cc.unitmesh.devti.llm2.TokenUsageEvent;
import cc.unitmesh.devti.llm2.TokenUsageListener;
import cc.unitmesh.devti.llms.custom.Usage;
import cc.unitmesh.devti.settings.model.LLMModelManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001aJ\u0006\u0010\"\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcc/unitmesh/devti/llm2/TokenUsageService;", "Lcc/unitmesh/devti/llm2/TokenUsageListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionTokenUsage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcc/unitmesh/devti/llms/custom/Usage;", "totalTokenUsage", "Ljava/util/concurrent/atomic/AtomicLong;", "totalPromptTokens", "totalCompletionTokens", "currentSessionId", "currentModel", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "setupTokenUsageListener", "", "onTokenUsage", "event", "Lcc/unitmesh/devti/llm2/TokenUsageEvent;", "getCurrentConsumedTokens", "getTotalConsumedTokens", "getUsedMaxToken", "", "calculateTokenAvailability", "", "calculateTokenUsageRatio", "isApproachingTokenLimit", "", "threshold", "getRemainingTokens", "dispose", "Companion", "core"})
public final class TokenUsageService
implements TokenUsageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, Usage> sessionTokenUsage;
    @NotNull
    private final AtomicLong totalTokenUsage;
    @NotNull
    private final AtomicLong totalPromptTokens;
    @NotNull
    private final AtomicLong totalCompletionTokens;
    @Nullable
    private String currentSessionId;
    @Nullable
    private String currentModel;
    @Nullable
    private MessageBusConnection messageBusConnection;

    public TokenUsageService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sessionTokenUsage = new ConcurrentHashMap();
        this.totalTokenUsage = new AtomicLong(0L);
        this.totalPromptTokens = new AtomicLong(0L);
        this.totalCompletionTokens = new AtomicLong(0L);
        this.setupTokenUsageListener();
    }

    private final void setupTokenUsageListener() {
        block0: {
            MessageBusConnection messageBusConnection = this.messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(TokenUsageListener.Companion.getTOPIC(), (Object)this);
        }
    }

    @Override
    public void onTokenUsage(@NotNull TokenUsageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getSessionId();
        if (string != null) {
            String sessionId = string;
            boolean bl = false;
            ((Map)this.sessionTokenUsage).put(sessionId, event.getUsage());
            this.currentSessionId = sessionId;
        }
        this.currentModel = event.getModel();
        this.totalTokenUsage.addAndGet(event.getUsage().getTotalTokens());
        this.totalPromptTokens.addAndGet(event.getUsage().getPromptTokens());
        this.totalCompletionTokens.addAndGet(event.getUsage().getCompletionTokens());
    }

    @NotNull
    public final Usage getCurrentConsumedTokens() {
        Object object;
        block3: {
            block2: {
                object = this.currentSessionId;
                if (object == null) break block2;
                String sessionId = object;
                boolean bl = false;
                Usage usage = this.sessionTokenUsage.get(sessionId);
                object = usage;
                if (usage != null) break block3;
            }
            object = new Usage(0L, 0L, 0L, 7, null);
        }
        return object;
    }

    @NotNull
    public final Usage getTotalConsumedTokens() {
        return new Usage(this.totalPromptTokens.get(), this.totalCompletionTokens.get(), this.totalTokenUsage.get());
    }

    public final long getUsedMaxToken() {
        Integer n = LLMModelManager.Companion.getInstance().getUsedMaxToken().getMaxContextWindowTokens();
        return n != null ? (long)n.intValue() : 0L;
    }

    public final double calculateTokenAvailability() {
        long maxTokens = this.getUsedMaxToken();
        if (maxTokens <= 0L) {
            return 1.0;
        }
        Usage currentUsage = this.getCurrentConsumedTokens();
        long usedTokens = currentUsage.getTotalTokens();
        return usedTokens >= maxTokens ? 0.0 : 1.0 - (double)usedTokens / (double)maxTokens;
    }

    public final double calculateTokenUsageRatio() {
        return 1.0 - this.calculateTokenAvailability();
    }

    public final boolean isApproachingTokenLimit(double threshold) {
        return this.calculateTokenUsageRatio() >= threshold;
    }

    public static /* synthetic */ boolean isApproachingTokenLimit$default(TokenUsageService tokenUsageService, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.8;
        }
        return tokenUsageService.isApproachingTokenLimit(d);
    }

    public final long getRemainingTokens() {
        long maxTokens = this.getUsedMaxToken();
        Usage currentUsage = this.getCurrentConsumedTokens();
        long remaining = maxTokens - currentUsage.getTotalTokens();
        return Math.max(0L, remaining);
    }

    public final void dispose() {
        MessageBusConnection messageBusConnection = this.messageBusConnection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.messageBusConnection = null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/llm2/TokenUsageService$Companion;", "", "<init>", "()V", "getInstance", "Lcc/unitmesh/devti/llm2/TokenUsageService;", "project", "Lcom/intellij/openapi/project/Project;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenUsageService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TokenUsageService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TokenUsageService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

