/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llm2;

import cc.unitmesh.devti.llm2.ApiToken;
import cc.unitmesh.devti.llm2.model.CopilotModelsResponse;
import com.intellij.openapi.diagnostic.Logger;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/llm2/GithubOAuthProvider;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "oauthToken", "", "apiToken", "Lcc/unitmesh/devti/llm2/ApiToken;", "supportedModels", "Lcc/unitmesh/devti/llm2/model/CopilotModelsResponse;", "extractOauthToken", "requestApiToken", "client", "Lokhttp3/OkHttpClient;", "getConfigDir", "Ljava/io/File;", "core"})
final class GithubOAuthProvider {
    @NotNull
    public static final GithubOAuthProvider INSTANCE = new GithubOAuthProvider();
    @NotNull
    private static final Logger logger;
    @Nullable
    private static String oauthToken;
    @Nullable
    private static ApiToken apiToken;
    @Nullable
    private static CopilotModelsResponse supportedModels;

    private GithubOAuthProvider() {
    }

    private final String extractOauthToken() {
        List arr;
        File configDir = this.getConfigDir();
        File appsFile = FilesKt.resolve((File)configDir, (String)"apps.json");
        if (!appsFile.exists()) {
            return null;
        }
        String it = FilesKt.readText$default((File)appsFile, null, (int)1, null);
        boolean bl = false;
        DocumentContext documentContext = JsonPath.parse((String)it);
        List list = arr = documentContext != null ? (List)documentContext.read("$..oauth_token", new Predicate[0]) : null;
        return list != null ? (String)CollectionsKt.lastOrNull((List)list) : null;
    }

    @Nullable
    public final ApiToken requestApiToken(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (oauthToken == null) {
            oauthToken = this.extractOauthToken();
        }
        if (oauthToken == null) {
            logger.warn("oauthToken not exists");
            return null;
        }
        ApiToken currentApiToken = apiToken;
        if (currentApiToken != null && currentApiToken.remainingSeconds() >= 300L) {
            return currentApiToken;
        }
        Request request2 = new Request.Builder().url("https://api.github.com/copilot_internal/v2/token").addHeader("Authorization", "token " + oauthToken).addHeader("Accept", "application/json").build();
        Response response = client.newCall(request2).execute();
        if (response.isSuccessful()) {
            ApiToken apiToken;
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new IllegalStateException("\u54cd\u5e94\u4f53\u4e3a\u7a7a");
            }
            Object responseBody = object;
            DocumentContext documentContext = JsonPath.parse((String)responseBody);
            if (documentContext == null) {
                throw new IllegalStateException("\u89e3\u6790\u54cd\u5e94\u5931\u8d25");
            }
            DocumentContext tokenResponse = documentContext;
            String string = (String)tokenResponse.read("$.token", new Predicate[0]);
            if (string == null) {
                throw new IllegalStateException("\u89e3\u6790 token \u5931\u8d25");
            }
            String apiKey = string;
            Integer n = (Integer)tokenResponse.read("$.expires_at", new Predicate[0]);
            if (n == null) {
                throw new IllegalStateException("\u89e3\u6790 expiresAt \u5931\u8d25");
            }
            int expiresAt = n;
            ApiToken it = apiToken = new ApiToken(apiKey, Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)expiresAt, (long)0L, (int)2, null));
            boolean bl = false;
            GithubOAuthProvider.apiToken = it;
            return apiToken;
        }
        Object object = response.body();
        if (object == null || (object = object.string()) == null) {
            throw new IllegalStateException("\u54cd\u5e94\u4f53\u4e3a\u7a7a");
        }
        Object errorBody = object;
        throw new IllegalStateException("\u83b7\u53d6 API \u4ee4\u724c\u5931\u8d25: " + (String)errorBody);
    }

    private final File getConfigDir() {
        String homeDir = System.getProperty("user.home");
        return new File(homeDir + "/.config/github-copilot/");
    }

    static {
        Logger logger = Logger.getInstance(GithubOAuthProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GithubOAuthProvider.logger = logger;
    }
}

