/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llm2;

import cc.unitmesh.devti.llm2.GithubCopilotDetector;
import cc.unitmesh.devti.llm2.model.CopilotModel;
import cc.unitmesh.devti.llm2.model.CopilotModelsResponse;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u0018\u0010\u001a\u001a\u00020\u00172\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J\u0006\u0010\u001c\u001a\u00020\u0017J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\b\u0002\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u001f\u001a\u00020\u00112\b\b\u0002\u0010 \u001a\u00020\u000fJ\b\u0010!\u001a\u00020\u0017H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcc/unitmesh/devti/llm2/GithubCopilotManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "client", "Lokhttp3/OkHttpClient;", "modelsCache", "", "Lcc/unitmesh/devti/llm2/model/CopilotModel;", "lastUpdateTime", "", "isInitialized", "", "isInitializing", "listeners", "", "Lcc/unitmesh/devti/llm2/GithubCopilotManager$ModelsUpdateListener;", "addListener", "", "listener", "removeListener", "notifyListeners", "models", "initialize", "getSupportedModels", "forceRefresh", "isCacheStale", "maxAgeMs", "dispose", "ModelsUpdateListener", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGithubCopilotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubCopilotManager.kt\ncc/unitmesh/devti/llm2/GithubCopilotManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1855#2,2:168\n*S KotlinDebug\n*F\n+ 1 GithubCopilotManager.kt\ncc/unitmesh/devti/llm2/GithubCopilotManager\n*L\n68#1:168,2\n*E\n"})
public final class GithubCopilotManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final OkHttpClient client;
    @Nullable
    private List<CopilotModel> modelsCache;
    private long lastUpdateTime;
    private boolean isInitialized;
    private boolean isInitializing;
    @NotNull
    private final List<ModelsUpdateListener> listeners;

    public GithubCopilotManager() {
        Logger logger = Logger.getInstance(GithubCopilotManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
        this.client = new OkHttpClient.Builder().build();
        this.listeners = new ArrayList();
    }

    public final void addListener(@NotNull ModelsUpdateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        if (this.isInitialized) {
            listener2.onModelsUpdated(this.modelsCache);
        }
    }

    public final void removeListener(@NotNull ModelsUpdateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    private final void notifyListeners(List<CopilotModel> models) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelsUpdateListener it = (ModelsUpdateListener)element$iv;
            boolean bl = false;
            it.onModelsUpdated(models);
        }
    }

    public final void initialize() {
        if (this.isInitialized || this.isInitializing) {
            return;
        }
        this.isInitializing = true;
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GithubCopilotManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!GithubCopilotDetector.INSTANCE.isGithubCopilotConfigured()) {
                            var2_3 = Unit.INSTANCE;
                            return var2_3;
                        }
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CopilotModelsResponse>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return GithubCopilotDetector.INSTANCE.getSupportedModels(true);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super CopilotModelsResponse> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var4_2) goto lbl14
lbl13:
                        // 1 sources

                        return var4_2;
lbl14:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            if ((modelsResponse = (CopilotModelsResponse)v0) == null) ** GOTO lbl28
                            models = modelsResponse.getData();
                            GithubCopilotManager.access$setModelsCache$p(this.this$0, models);
                            GithubCopilotManager.access$setLastUpdateTime$p(this.this$0, System.currentTimeMillis());
                            GithubCopilotManager.access$setInitialized$p(this.this$0, true);
                            GithubCopilotManager.access$getLogger$p(this.this$0).info("GitHub Copilot models initialized successfully: " + models.size() + " models available");
                            GithubCopilotManager.access$notifyListeners(this.this$0, models);
                            ** GOTO lbl29
lbl28:
                            // 1 sources

                            GithubCopilotManager.access$getLogger$p(this.this$0).warn("Failed to initialize GitHub Copilot models");
                        }
                        catch (Exception e) {
                            GithubCopilotManager.access$getLogger$p(this.this$0).warn("Error initializing GitHub Copilot models", (Throwable)e);
                        }
                        catch (Throwable var2_6) {
                            throw var2_6;
                        }
lbl29:
                        // 2 sources

                        GithubCopilotManager.access$setInitializing$p(this.this$0, false);
                        ** GOTO lbl39
                    }
                    {
                        finally {
                            GithubCopilotManager.access$setInitializing$p(this.this$0, false);
                        }
                    }
lbl39:
                    // 2 sources

                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final List<CopilotModel> getSupportedModels(boolean forceRefresh) {
        if (forceRefresh) {
            Object object;
            CopilotModelsResponse freshModelsResponse = GithubCopilotDetector.INSTANCE.getSupportedModels(true);
            if (freshModelsResponse != null) {
                List<CopilotModel> freshModels = freshModelsResponse.getData();
                this.modelsCache = freshModels;
                this.lastUpdateTime = System.currentTimeMillis();
                this.isInitialized = true;
                this.notifyListeners(this.modelsCache);
            }
            if ((object = freshModelsResponse) == null || (object = ((CopilotModelsResponse)object).getData()) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }
        return this.modelsCache;
    }

    public static /* synthetic */ List getSupportedModels$default(GithubCopilotManager githubCopilotManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return githubCopilotManager.getSupportedModels(bl);
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final boolean isCacheStale(long maxAgeMs) {
        return System.currentTimeMillis() - this.lastUpdateTime > maxAgeMs;
    }

    public static /* synthetic */ boolean isCacheStale$default(GithubCopilotManager githubCopilotManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 3600000L;
        }
        return githubCopilotManager.isCacheStale(l);
    }

    public void dispose() {
        this.listeners.clear();
    }

    @JvmStatic
    @NotNull
    public static final GithubCopilotManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ void access$setModelsCache$p(GithubCopilotManager $this, List list) {
        $this.modelsCache = list;
    }

    public static final /* synthetic */ void access$setLastUpdateTime$p(GithubCopilotManager $this, long l) {
        $this.lastUpdateTime = l;
    }

    public static final /* synthetic */ void access$setInitialized$p(GithubCopilotManager $this, boolean bl) {
        $this.isInitialized = bl;
    }

    public static final /* synthetic */ Logger access$getLogger$p(GithubCopilotManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$notifyListeners(GithubCopilotManager $this, List models) {
        $this.notifyListeners(models);
    }

    public static final /* synthetic */ void access$setInitializing$p(GithubCopilotManager $this, boolean bl) {
        $this.isInitializing = bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/devti/llm2/GithubCopilotManager$Companion;", "", "<init>", "()V", "getInstance", "Lcc/unitmesh/devti/llm2/GithubCopilotManager;", "core"})
    @SourceDebugExtension(value={"SMAP\nGithubCopilotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubCopilotManager.kt\ncc/unitmesh/devti/llm2/GithubCopilotManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,167:1\n42#2,3:168\n*S KotlinDebug\n*F\n+ 1 GithubCopilotManager.kt\ncc/unitmesh/devti/llm2/GithubCopilotManager$Companion\n*L\n163#1:168,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GithubCopilotManager getInstance() {
            boolean $i$f$service = false;
            Class<GithubCopilotManager> serviceClass$iv = GithubCopilotManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GithubCopilotManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/devti/llm2/GithubCopilotManager$ModelsUpdateListener;", "", "onModelsUpdated", "", "models", "", "Lcc/unitmesh/devti/llm2/model/CopilotModel;", "core"})
    public static interface ModelsUpdateListener {
        public void onModelsUpdated(@Nullable List<CopilotModel> var1);
    }
}

