/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llm2;

import cc.unitmesh.devti.llm2.model.CopilotModel;
import cc.unitmesh.devti.llm2.model.CopilotModelsResponse;
import cc.unitmesh.devti.llm2.model.ModelPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0014\u001a\u00020\u000fJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/llm2/GithubCopilotDetector;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cachedModels", "Lcc/unitmesh/devti/llm2/model/CopilotModelsResponse;", "modelsLastUpdated", "", "TYPE_EMBEDDING", "", "TYPE_COMPLETION", "isGithubCopilotConfigured", "", "extractOauthToken", "getConfigDir", "Ljava/io/File;", "getSupportedModels", "forceRefresh", "requestApiToken", "Lcc/unitmesh/devti/llm2/GithubCopilotDetector$ApiToken;", "client", "Lokhttp3/OkHttpClient;", "oauthToken", "ApiToken", "core"})
@SourceDebugExtension(value={"SMAP\nGithubCopilotDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubCopilotDetector.kt\ncc/unitmesh/devti/llm2/GithubCopilotDetector\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n222#2:193\n766#3:194\n857#3,2:195\n*S KotlinDebug\n*F\n+ 1 GithubCopilotDetector.kt\ncc/unitmesh/devti/llm2/GithubCopilotDetector\n*L\n117#1:193\n121#1:194\n121#1:195,2\n*E\n"})
public final class GithubCopilotDetector {
    @NotNull
    public static final GithubCopilotDetector INSTANCE = new GithubCopilotDetector();
    @NotNull
    private static final Logger logger;
    @Nullable
    private static CopilotModelsResponse cachedModels;
    private static long modelsLastUpdated;
    @NotNull
    public static final String TYPE_EMBEDDING = "embedding";
    @NotNull
    public static final String TYPE_COMPLETION = "completion";

    private GithubCopilotDetector() {
    }

    public final boolean isGithubCopilotConfigured() {
        return this.extractOauthToken() != null;
    }

    @Nullable
    public final String extractOauthToken() {
        List arr;
        File configDir = this.getConfigDir();
        File appsFile = FilesKt.resolve((File)configDir, (String)"apps.json");
        if (!appsFile.exists()) {
            return null;
        }
        String it = FilesKt.readText$default((File)appsFile, null, (int)1, null);
        boolean bl = false;
        DocumentContext documentContext = JsonPath.parse((String)it);
        List list = arr = documentContext != null ? (List)documentContext.read("$..oauth_token", new Predicate[0]) : null;
        return list != null ? (String)CollectionsKt.lastOrNull((List)list) : null;
    }

    private final File getConfigDir() {
        String homeDir = System.getProperty("user.home");
        return new File(homeDir + "/.config/github-copilot/");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CopilotModelsResponse getSupportedModels(boolean forceRefresh) {
        CopilotModelsResponse copilotModelsResponse;
        long currentTime = System.currentTimeMillis();
        if (!forceRefresh && cachedModels != null && currentTime - modelsLastUpdated < 3600000L) {
            return cachedModels;
        }
        String oauthToken = this.extractOauthToken();
        if (oauthToken == null) {
            logger.warn("Failed to get supported models: OAuth token not found");
            return null;
        }
        OkHttpClient client = new OkHttpClient.Builder().build();
        ApiToken apiToken = this.requestApiToken(client, oauthToken);
        if (apiToken == null) {
            logger.warn("Failed to get supported models: API token not found");
            return null;
        }
        Request request2 = new Request.Builder().url("https://api.githubcopilot.com/models").addHeader("Authorization", "Bearer " + apiToken.getToken()).addHeader("Editor-Version", "Neovim/0.6.1").addHeader("Content-Type", "application/json").addHeader("Copilot-Integration-Id", "vscode-chat").build();
        try {
            CopilotModelsResponse copilotModelsResponse2;
            Response response = client.newCall(request2).execute();
            if (response.isSuccessful()) {
                CopilotModelsResponse copilotModelsResponse3;
                String responseBody;
                ResponseBody responseBody2 = response.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (responseBody == null) {
                    logger.warn("Failed to get supported models: Response body is empty");
                    return null;
                }
                try {
                    CopilotModelsResponse models;
                    int filteredCount;
                    void $this$filterTo$iv$iv;
                    Json json = JsonKt.Json$default(null, GithubCopilotDetector::getSupportedModels$lambda$1, (int)1, null);
                    logger.info(responseBody);
                    Json this_$iv = json;
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    CopilotModelsResponse parsedResponse = (CopilotModelsResponse)this_$iv.decodeFromString((DeserializationStrategy)CopilotModelsResponse.Companion.serializer(), responseBody);
                    Iterable $this$filter$iv = parsedResponse.getData();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        CopilotModel model = (CopilotModel)element$iv$iv;
                        boolean bl = false;
                        ModelPolicy modelPolicy = model.getPolicy();
                        if (!(Intrinsics.areEqual((Object)(modelPolicy != null ? modelPolicy.getState() : null), (Object)"enabled") || model.getPolicy() == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List filteredModels = (List)destination$iv$iv;
                    int originalCount = parsedResponse.getData().size();
                    if (originalCount != (filteredCount = filteredModels.size())) {
                        logger.info("Filtered GitHub Copilot models: " + originalCount + " -> " + filteredCount + " (removed " + (originalCount - filteredCount) + " disabled models)");
                    }
                    cachedModels = models = new CopilotModelsResponse(filteredModels);
                    modelsLastUpdated = currentTime;
                    copilotModelsResponse3 = models;
                }
                catch (Exception e) {
                    logger.warn("Failed to parse supported models response", (Throwable)e);
                    copilotModelsResponse3 = null;
                }
                copilotModelsResponse2 = copilotModelsResponse3;
            } else {
                logger.warn("Failed to get supported models: " + response.code());
                copilotModelsResponse2 = null;
            }
            copilotModelsResponse = copilotModelsResponse2;
        }
        catch (Exception e) {
            logger.warn("Exception while getting supported models", (Throwable)e);
            copilotModelsResponse = null;
        }
        return copilotModelsResponse;
    }

    public static /* synthetic */ CopilotModelsResponse getSupportedModels$default(GithubCopilotDetector githubCopilotDetector, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return githubCopilotDetector.getSupportedModels(bl);
    }

    private final ApiToken requestApiToken(OkHttpClient client, String oauthToken) {
        ApiToken apiToken;
        Request request2 = new Request.Builder().url("https://api.github.com/copilot_internal/v2/token").addHeader("Authorization", "token " + oauthToken).addHeader("Accept", "application/json").build();
        try {
            ApiToken apiToken2;
            Response response = client.newCall(request2).execute();
            if (response.isSuccessful()) {
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    throw new IllegalStateException("Response body is empty");
                }
                Object responseBody = object;
                DocumentContext documentContext = JsonPath.parse((String)responseBody);
                if (documentContext == null) {
                    throw new IllegalStateException("Failed to parse response");
                }
                DocumentContext tokenResponse = documentContext;
                String string = (String)tokenResponse.read("$.token", new Predicate[0]);
                if (string == null) {
                    throw new IllegalStateException("Failed to parse token");
                }
                String token = string;
                Integer n = (Integer)tokenResponse.read("$.expires_at", new Predicate[0]);
                if (n == null) {
                    throw new IllegalStateException("Failed to parse expiresAt");
                }
                int expiresAt = n;
                apiToken2 = new ApiToken(token, expiresAt);
            } else {
                logger.warn("Failed to get API token: " + response.code());
                apiToken2 = null;
            }
            apiToken = apiToken2;
        }
        catch (Exception e) {
            logger.warn("Exception while getting API token", (Throwable)e);
            apiToken = null;
        }
        return apiToken;
    }

    private static final Unit getSupportedModels$lambda$1(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(GithubCopilotDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GithubCopilotDetector.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/llm2/GithubCopilotDetector$ApiToken;", "", "token", "", "expiresAt", "", "<init>", "(Ljava/lang/String;I)V", "getToken", "()Ljava/lang/String;", "getExpiresAt", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class ApiToken {
        @NotNull
        private final String token;
        private final int expiresAt;

        public ApiToken(@NotNull String token, int expiresAt) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
            this.expiresAt = expiresAt;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        public final int getExpiresAt() {
            return this.expiresAt;
        }

        @NotNull
        public final String component1() {
            return this.token;
        }

        public final int component2() {
            return this.expiresAt;
        }

        @NotNull
        public final ApiToken copy(@NotNull String token, int expiresAt) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return new ApiToken(token, expiresAt);
        }

        public static /* synthetic */ ApiToken copy$default(ApiToken apiToken, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = apiToken.token;
            }
            if ((n2 & 2) != 0) {
                n = apiToken.expiresAt;
            }
            return apiToken.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ApiToken(token=" + this.token + ", expiresAt=" + this.expiresAt + ")";
        }

        public int hashCode() {
            int result = this.token.hashCode();
            result = result * 31 + Integer.hashCode(this.expiresAt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApiToken)) {
                return false;
            }
            ApiToken apiToken = (ApiToken)other;
            if (!Intrinsics.areEqual((Object)this.token, (Object)apiToken.token)) {
                return false;
            }
            return this.expiresAt == apiToken.expiresAt;
        }
    }
}

