/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.llm2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/llm2/ApiToken;", "", "apiKey", "", "expiresAt", "Lkotlinx/datetime/Instant;", "<init>", "(Ljava/lang/String;Lkotlinx/datetime/Instant;)V", "getApiKey", "()Ljava/lang/String;", "getExpiresAt", "()Lkotlinx/datetime/Instant;", "remainingSeconds", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
final class ApiToken {
    @NotNull
    private final String apiKey;
    @NotNull
    private final Instant expiresAt;

    public ApiToken(@NotNull String apiKey, @NotNull Instant expiresAt) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)expiresAt, (String)"expiresAt");
        this.apiKey = apiKey;
        this.expiresAt = expiresAt;
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    @NotNull
    public final Instant getExpiresAt() {
        return this.expiresAt;
    }

    public final long remainingSeconds() {
        Instant now = Clock.System.INSTANCE.now();
        return this.expiresAt.getEpochSeconds() - now.getEpochSeconds();
    }

    @NotNull
    public final String component1() {
        return this.apiKey;
    }

    @NotNull
    public final Instant component2() {
        return this.expiresAt;
    }

    @NotNull
    public final ApiToken copy(@NotNull String apiKey, @NotNull Instant expiresAt) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)expiresAt, (String)"expiresAt");
        return new ApiToken(apiKey, expiresAt);
    }

    public static /* synthetic */ ApiToken copy$default(ApiToken apiToken, String string, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            string = apiToken.apiKey;
        }
        if ((n & 2) != 0) {
            instant = apiToken.expiresAt;
        }
        return apiToken.copy(string, instant);
    }

    @NotNull
    public String toString() {
        return "ApiToken(apiKey=" + this.apiKey + ", expiresAt=" + this.expiresAt + ")";
    }

    public int hashCode() {
        int result = this.apiKey.hashCode();
        result = result * 31 + this.expiresAt.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ApiToken)) {
            return false;
        }
        ApiToken apiToken = (ApiToken)other;
        if (!Intrinsics.areEqual((Object)this.apiKey, (Object)apiToken.apiKey)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expiresAt, (Object)apiToken.expiresAt);
    }
}

