/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0001\u00a8\u0006\n"}, d2={"lookupFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/project/Project;", "path", "", "findFile", "filename", "caseSensitively", "", "canBeAdded", "devins-lang"})
public final class ProjectFileUtilKt {
    @Nullable
    public static final VirtualFile lookupFile(@NotNull Project $this$lookupFile, @NotNull String path) {
        Path projectPath;
        Intrinsics.checkNotNullParameter((Object)$this$lookupFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$lookupFile);
        Path path2 = projectPath = virtualFile != null ? virtualFile.toNioPath() : null;
        Path realpath = path2 != null ? path2.resolve(path) : null;
        Path path3 = realpath;
        return VirtualFileManager.getInstance().findFileByUrl("file://" + (path3 != null ? path3.toAbsolutePath() : null));
    }

    @Nullable
    public static final VirtualFile findFile(@NotNull Project $this$findFile, @NotNull String filename, boolean caseSensitively) {
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection collection = FilenameIndex.getVirtualFilesByName((String)filename, (GlobalSearchScope)ProjectScope.getContentScope((Project)$this$findFile));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        return (VirtualFile)CollectionsKt.firstOrNull((Iterable)collection);
    }

    public static /* synthetic */ VirtualFile findFile$default(Project project, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ProjectFileUtilKt.findFile(project, string, bl);
    }

    public static final boolean canBeAdded(@NotNull VirtualFile $this$canBeAdded) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeAdded, (String)"<this>");
        if (!$this$canBeAdded.isValid() || $this$canBeAdded.isDirectory()) {
            return false;
        }
        return !$this$canBeAdded.getFileType().isBinary() && !FileUtilRt.isTooLarge((long)$this$canBeAdded.getLength());
    }
}

