/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.processor.shell;

import cc.unitmesh.devti.envior.ShireEnvReader;
import cc.unitmesh.devti.envior.ShireEnvVariableFiller;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\rJ*\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/language/processor/shell/ShireShellCommandRunner;", "", "<init>", "()V", "DEFAULT_TIMEOUT", "", "fill", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "processVariables", "", "runShellCommand", "virtualFile", "myProject", "deleteFileOnTermination", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "tempFile", "Ljava/io/File;", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nShireShellCommandRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShireShellCommandRunner.kt\ncc/unitmesh/devti/language/processor/shell/ShireShellCommandRunner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n11#2:83\n1#3:84\n*S KotlinDebug\n*F\n+ 1 ShireShellCommandRunner.kt\ncc/unitmesh/devti/language/processor/shell/ShireShellCommandRunner\n*L\n69#1:83\n*E\n"})
public final class ShireShellCommandRunner {
    @NotNull
    public static final ShireShellCommandRunner INSTANCE = new ShireShellCommandRunner();
    private static final int DEFAULT_TIMEOUT = 30000;

    private ShireShellCommandRunner() {
    }

    @NotNull
    public final String fill(@NotNull Project project, @NotNull VirtualFile file, @NotNull Map<String, String> processVariables) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(processVariables, (String)"processVariables");
        return (String)ActionsKt.runReadAction(() -> ShireShellCommandRunner.fill$lambda$0(project, file, processVariables));
    }

    @NotNull
    public final String runShellCommand(@NotNull VirtualFile virtualFile, @NotNull Project myProject, @NotNull Map<String, String> processVariables) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter(processVariables, (String)"processVariables");
        String string = virtualFile.getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String workingDirectory = string;
        String fileContent = this.fill(myProject, virtualFile, processVariables);
        File tempFile = File.createTempFile("tempScript", ".sh");
        Intrinsics.checkNotNull((Object)tempFile);
        FilesKt.writeText$default((File)tempFile, (String)fileContent, null, (int)2, null);
        Object object = new String[]{tempFile.getPath()};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(workingDirectory).withCharset(StandardCharsets.UTF_8).withExePath("sh").withParameters(object);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> ShireShellCommandRunner.runShellCommand$lambda$3(commandLine, tempFile));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        Future future2 = future;
        try {
            object = future2.get();
            Intrinsics.checkNotNull((Object)object);
            object = (String)object;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ShireShellCommandRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Command execution failed", (Throwable)e);
            throw new RuntimeException("Execution failed: " + e.getMessage(), e);
        }
        return object;
    }

    private final void deleteFileOnTermination(GeneralCommandLine commandLine, File tempFile) {
        OSProcessHandler.deleteFileOnTermination((GeneralCommandLine)commandLine, (File)tempFile);
    }

    private static final String fill$lambda$0(Project $project, VirtualFile $file, Map $processVariables) {
        GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getContentScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        String string = (String)CollectionsKt.firstOrNull((Iterable)ShireEnvReader.INSTANCE.getAllEnvironments($project, scope));
        if (string == null) {
            string = "development";
        }
        String envName = string;
        JsonObject envObject = ShireEnvReader.INSTANCE.getEnvObject(envName, scope, $project);
        String content = ProjectFileUtilKt.readText($file);
        List<Set<String>> envVariables = ShireEnvReader.INSTANCE.fetchEnvironmentVariables(envName, scope);
        String filledContent = ShireEnvVariableFiller.INSTANCE.fillVariables(content, envVariables, envObject, $processVariables);
        return filledContent;
    }

    private static final String runShellCommand$lambda$3(GeneralCommandLine $commandLine, File $tempFile) {
        Object $this$runShellCommand_u24lambda_u243_u24lambda_u241;
        Object object = INSTANCE;
        try {
            $this$runShellCommand_u24lambda_u243_u24lambda_u241 = object;
            boolean bl = false;
            $this$runShellCommand_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)new CapturingProcessHandler($commandLine).runProcess(30000));
        }
        catch (Throwable bl) {
            $this$runShellCommand_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        Object $this$runShellCommand_u24lambda_u243_u24lambda_u242 = object = $this$runShellCommand_u24lambda_u243_u24lambda_u241;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$tempFile);
        INSTANCE.deleteFileOnTermination($commandLine, $tempFile);
        ResultKt.throwOnFailure((Object)object);
        ProcessOutput processOutput = (ProcessOutput)object;
        int exitCode2 = processOutput.getExitCode();
        if (exitCode2 != 0) {
            throw new RuntimeException("Cannot execute " + $commandLine + ": exit code " + exitCode2 + ", error output: " + processOutput.getStderr());
        }
        return processOutput.getStdout();
    }
}

