/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.processor;

import cc.unitmesh.devti.devins.provider.http.HttpHandler;
import cc.unitmesh.devti.devins.provider.http.HttpHandlerType;
import cc.unitmesh.devti.language.actions.DevInsRunFileAction;
import cc.unitmesh.devti.language.ast.action.PatternActionFuncDef;
import cc.unitmesh.devti.language.ast.action.PatternProcessor;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import cc.unitmesh.devti.language.processor.shell.ShireShellCommandRunner;
import cc.unitmesh.devti.language.psi.DevInFile;
import cc.unitmesh.devti.language.service.ConsoleService;
import cc.unitmesh.devti.provider.RunService;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0012J2\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018JC\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/language/processor/ThreadProcessor;", "Lcc/unitmesh/devti/language/ast/action/PatternProcessor;", "<init>", "()V", "type", "Lcc/unitmesh/devti/language/ast/action/PatternActionFuncDef;", "getType", "()Lcc/unitmesh/devti/language/ast/action/PatternActionFuncDef;", "execute", "", "myProject", "Lcom/intellij/openapi/project/Project;", "fileName", "variablesName", "", "variableTable", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeShFile", "psiFile", "Lcom/intellij/sh/psi/ShFile;", "processVariables", "", "(Lcom/intellij/sh/psi/ShFile;Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeTask", "variables", "Lcc/unitmesh/devti/language/psi/DevInFile;", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Ljava/util/Map;Lcc/unitmesh/devti/language/psi/DevInFile;)Ljava/lang/String;", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nThreadProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadProcessor.kt\ncc/unitmesh/devti/language/processor/ThreadProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,121:1\n1603#2,9:122\n1855#2:131\n1856#2:133\n1612#2:134\n1#3:132\n9226#4,2:135\n9376#4,4:137\n*S KotlinDebug\n*F\n+ 1 ThreadProcessor.kt\ncc/unitmesh/devti/language/processor/ThreadProcessor\n*L\n60#1:122,9\n60#1:131\n60#1:133\n60#1:134\n60#1:132\n90#1:135,2\n90#1:137,4\n*E\n"})
public final class ThreadProcessor
implements PatternProcessor {
    @NotNull
    public static final ThreadProcessor INSTANCE = new ThreadProcessor();
    @NotNull
    private static final PatternActionFuncDef type = PatternActionFuncDef.THREAD;

    private ThreadProcessor() {
    }

    @Override
    @NotNull
    public PatternActionFuncDef getType() {
        return type;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object execute(@NotNull Project myProject, @NotNull String fileName, @NotNull String[] variablesName, @NotNull Map<String, Object> variableTable, @NotNull Continuation<? super String> $completion) {
        HttpHandler httpHandler;
        VirtualFile virtualFile = cc.unitmesh.devti.language.utils.ProjectFileUtilKt.lookupFile(myProject, fileName);
        if (virtualFile == null) {
            return "File not found: " + fileName;
        }
        VirtualFile file = virtualFile;
        ConsoleService consoleService = ConsoleService.Companion.getInstance(myProject);
        String string = "Executing thread for file: " + fileName + "\n";
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        consoleService.print(string, consoleViewContentType);
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String filename = string3;
        String content = ProjectFileUtilKt.readText(file);
        if (StringsKt.endsWith$default((String)filename, (String)".curl.sh", (boolean)false, (int)2, null)) {
            String execute2;
            httpHandler = HttpHandler.Companion.provide(HttpHandlerType.CURL);
            String string4 = execute2 = httpHandler != null ? httpHandler.execute(myProject, content, variablesName, variableTable) : null;
            if (execute2 != null) {
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
                consoleService.print("cURL execution completed\n", consoleViewContentType2);
                return execute2;
            }
        }
        PsiFile psiFile2 = (PsiFile)ReadAction.compute(() -> ThreadProcessor.execute$lambda$0(myProject, file));
        if (psiFile2 == null) {
            return "Failed to find PSI file for " + fileName;
        }
        PsiFile psiFile3 = psiFile2;
        String string5 = "Running " + fileName + "...\n";
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"NORMAL_OUTPUT");
        consoleService.print(string5, consoleViewContentType3);
        httpHandler = psiFile3;
        if (httpHandler instanceof DevInFile) {
            String string6;
            Object output = variableTable.get("output");
            if (output instanceof List) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)output;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    String string7;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Object it = element$iv$iv;
                    boolean bl2 = false;
                    try {
                        variableTable.put("output", it);
                        string7 = INSTANCE.executeTask(myProject, variablesName, variableTable, (DevInFile)psiFile3);
                    }
                    catch (Exception e) {
                        String string8 = "Error: " + e.getMessage() + "\n";
                        ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.ERROR_OUTPUT;
                        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"ERROR_OUTPUT");
                        consoleService.print(string8, consoleViewContentType4);
                        string7 = null;
                    }
                    if (string7 == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List results2 = (List)destination$iv$iv;
                string6 = CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            } else if (output instanceof Object[]) {
                string6 = ArraysKt.joinToString$default((Object[])((Object[])output), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ThreadProcessor.execute$lambda$2(variableTable, myProject, variablesName, psiFile3, arg_0), (int)30, null);
            } else {
                Object object = this.executeTask(myProject, variablesName, variableTable, (DevInFile)psiFile3);
                if (object == null) {
                    object = DevInErrorKt.getDEVINS_ERROR() + " - Thread: No run service found";
                }
                return object;
            }
            return string6;
        }
        if (httpHandler instanceof ShFile) {
            String[] $this$associateWith$iv = variablesName;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
            String[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            int n = $this$associateWithTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                void it;
                String element$iv$iv;
                String string9 = element$iv$iv = $this$associateWithTo$iv$iv[i];
                String string10 = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                Object object = variableTable.get(it);
                String string11 = object instanceof String ? (String)object : null;
                if (string11 == null) {
                    string11 = "";
                }
                String string12 = string11;
                map.put(string10, string12);
            }
            Map processVariables = result$iv;
            return this.executeShFile((ShFile)psiFile3, myProject, processVariables, $completion);
        }
        RunService runService = RunService.Companion.provider(myProject, file);
        if (runService == null) {
            return DevInErrorKt.getDEVINS_ERROR() + " No run service found for " + psiFile3 + ", " + fileName;
        }
        RunService fileRunService = runService;
        Object object = fileRunService.runFileAsync(myProject, file, (PsiElement)psiFile3);
        if (object == null) {
            object = DevInErrorKt.getDEVINS_ERROR() + " Run service failure: " + fileName;
        }
        return object;
    }

    @Nullable
    public final Object executeShFile(@NotNull ShFile psiFile2, @NotNull Project myProject, @NotNull Map<String, String> processVariables, @NotNull Continuation<? super String> $completion) {
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if ((ShRunner)ApplicationManager.getApplication().getService(ShRunner.class) == null) {
            return DevInErrorKt.getDEVINS_ERROR() + ": Shell runner not found";
        }
        Intrinsics.checkNotNull((Object)virtualFile);
        return ShireShellCommandRunner.INSTANCE.runShellCommand(virtualFile, myProject, processVariables);
    }

    private final String executeTask(Project myProject, String[] variables, Map<String, Object> variableTable, DevInFile psiFile2) {
        return DevInsRunFileAction.Companion.suspendExecuteFile(myProject, psiFile2, variables, variableTable);
    }

    private static final PsiFile execute$lambda$0(Project $myProject, VirtualFile $file) {
        return PsiManager.getInstance((Project)$myProject).findFile($file);
    }

    private static final CharSequence execute$lambda$2(Map $variableTable, Project $myProject, String[] $variablesName, PsiFile $psiFile, Object it) {
        $variableTable.put("output", it);
        String string = INSTANCE.executeTask($myProject, $variablesName, $variableTable, (DevInFile)$psiFile);
        return string != null ? (CharSequence)string : (CharSequence)(DevInErrorKt.getDEVINS_ERROR() + " - Thread: No run service found");
    }
}

