/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.processor;

import cc.unitmesh.devti.language.ast.action.PatternActionFunc;
import cc.unitmesh.devti.language.ast.action.PatternActionFuncDef;
import cc.unitmesh.devti.language.ast.action.PatternProcessor;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/language/processor/JsonPathProcessor;", "Lcc/unitmesh/devti/language/ast/action/PatternProcessor;", "<init>", "()V", "type", "Lcc/unitmesh/devti/language/ast/action/PatternActionFuncDef;", "getType", "()Lcc/unitmesh/devti/language/ast/action/PatternActionFuncDef;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "jsonStr", "action", "Lcc/unitmesh/devti/language/ast/action/PatternActionFunc$JsonPath;", "console", "", "str", "parseSSEResult", "input", "jsonPath", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nJsonPathProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonPathProcessor.kt\ncc/unitmesh/devti/language/processor/JsonPathProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n766#2:82\n857#2,2:83\n1549#2:85\n1620#2,3:86\n1603#2,9:89\n1855#2:98\n1856#2:101\n1612#2:102\n11#3:99\n1#4:100\n*S KotlinDebug\n*F\n+ 1 JsonPathProcessor.kt\ncc/unitmesh/devti/language/processor/JsonPathProcessor\n*L\n66#1:82\n66#1:83,2\n68#1:85\n68#1:86,3\n70#1:89,9\n70#1:98\n70#1:101\n70#1:102\n74#1:99\n70#1:100\n*E\n"})
public final class JsonPathProcessor
implements PatternProcessor {
    @NotNull
    public static final JsonPathProcessor INSTANCE = new JsonPathProcessor();
    @NotNull
    private static final PatternActionFuncDef type = PatternActionFuncDef.JSONPATH;

    private JsonPathProcessor() {
    }

    @Override
    @NotNull
    public PatternActionFuncDef getType() {
        return type;
    }

    @Nullable
    public final String execute(@NotNull Project project, @NotNull String jsonStr, @NotNull PatternActionFunc.JsonPath action) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jsonStr, (String)"jsonStr");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (action.getSseMode() || StringsKt.startsWith$default((String)jsonStr, (String)"data: ", (boolean)false, (int)2, null)) {
            return this.parseSSEResult(jsonStr, ((Object)StringsKt.trim((CharSequence)action.getPath())).toString());
        }
        try {
            DocumentContext documentContext = JsonPath.parse((String)jsonStr);
            string = String.valueOf(documentContext != null ? documentContext.read(((Object)StringsKt.trim((CharSequence)action.getPath())).toString(), new Predicate[0]) : null);
        }
        catch (Exception e) {
            this.console(project, "jsonpath error: " + e);
            return null;
        }
        String result = string;
        if (Intrinsics.areEqual((Object)result, (Object)"null")) {
            this.console(project, "jsonpath error: " + result + " for " + jsonStr);
            return null;
        }
        return result;
    }

    public final void console(@NotNull Project project, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)runContentManager, (String)"getInstance(...)");
        RunContentManager contentManager = runContentManager;
        RunContentDescriptor runContentDescriptor = contentManager.getSelectedContent();
        ExecutionConsole executionConsole = runContentDescriptor != null ? runContentDescriptor.getExecutionConsole() : null;
        ConsoleViewWrapperBase consoleViewWrapperBase = executionConsole instanceof ConsoleViewWrapperBase ? (ConsoleViewWrapperBase)executionConsole : null;
        if (consoleViewWrapperBase == null) {
            return;
        }
        ConsoleViewWrapperBase console2 = consoleViewWrapperBase;
        console2.print(str, ConsoleViewContentType.ERROR_OUTPUT);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String parseSSEResult(@NotNull String input, @NotNull String jsonPath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"data: ", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                DocumentContext documentContext = JsonPath.parse((String)it2);
                object = documentContext != null ? documentContext.read(jsonPath, new Predicate[0]) : null;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JsonPathProcessor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("jsonpath error: " + e);
                object = null;
            }
            if (object == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dataLines = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)dataLines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

