/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.parser;

import cc.unitmesh.devti.language.parser.CodeBlockElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/language/parser/CodeBlockLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcc/unitmesh/devti/language/parser/CodeBlockElement;", "host", "<init>", "(Lcc/unitmesh/devti/language/parser/CodeBlockElement;)V", "getRelevantTextRange", "Lcom/intellij/openapi/util/TextRange;", "isOneLine", "", "decode", "rangeInsideHost", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "devins-lang"})
public final class CodeBlockLiteralTextEscaper
extends LiteralTextEscaper<CodeBlockElement> {
    public CodeBlockLiteralTextEscaper(@NotNull CodeBlockElement host) {
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        super((PsiLanguageInjectionHost)host);
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost, (String)"myHost");
        return CodeBlockElement.Companion.obtainRelevantTextRange((CodeBlockElement)psiLanguageInjectionHost);
    }

    public boolean isOneLine() {
        return false;
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost, (String)"myHost");
        List<PsiElement> list = CodeBlockElement.Companion.obtainFenceContent((CodeBlockElement)psiLanguageInjectionHost);
        if (list == null) {
            return true;
        }
        List<PsiElement> elements = list;
        for (PsiElement element : elements) {
            TextRange intersected;
            if (rangeInsideHost.intersection(element.getTextRangeInParent()) == null) continue;
            outChars.append(intersected.substring(((CodeBlockElement)this.myHost).getText()));
        }
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost, (String)"myHost");
        List<PsiElement> list = CodeBlockElement.Companion.obtainFenceContent((CodeBlockElement)psiLanguageInjectionHost);
        if (list == null) {
            return -1;
        }
        List<PsiElement> elements = list;
        int cur = 0;
        for (PsiElement element : elements) {
            TextRange intersected = rangeInsideHost.intersection(element.getTextRangeInParent());
            if (intersected == null || intersected.isEmpty()) continue;
            if (cur + intersected.getLength() == offsetInDecoded) {
                return intersected.getStartOffset() + intersected.getLength();
            }
            if (cur == offsetInDecoded) {
                return intersected.getStartOffset();
            }
            if (cur < offsetInDecoded && cur + intersected.getLength() > offsetInDecoded) {
                return intersected.getStartOffset() + (offsetInDecoded - cur);
            }
            cur += intersected.getLength();
        }
        PsiElement last = elements.get(elements.size() - 1);
        TextRange intersected = rangeInsideHost.intersection(last.getTextRangeInParent());
        if (intersected == null || intersected.isEmpty()) {
            return -1;
        }
        int result = intersected.getStartOffset() + (offsetInDecoded - (cur - intersected.getLength()));
        return rangeInsideHost.getStartOffset() <= result && result <= rangeInsideHost.getEndOffset() ? result : -1;
    }
}

