/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.language.middleware.builtin.psi.PsiErrorCollector;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/VerifyCodeProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "", "devins-lang"})
public final class VerifyCodeProcessor
implements PostProcessor {
    @NotNull
    private final String processorName = PostProcessorType.VerifyCode.getHandleName();
    @NotNull
    private final String description;

    public VerifyCodeProcessor() {
        this.description = "`verifyCode` will verify the code syntax and return the errors";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public String execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        List<String> errors;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Object code = context.getPipeData().get("output");
                if (!(code instanceof VirtualFile)) {
                    ConsoleView consoleView = console2;
                    if (consoleView != null) {
                        consoleView.print("No code to verify\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                    return "";
                }
                PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile((VirtualFile)code);
                if (psiFile2 == null) {
                    ConsoleView consoleView = console2;
                    if (consoleView != null) {
                        consoleView.print("No code to verify\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                    return "";
                }
                if (!psiFile2.isValid()) {
                    ConsoleView consoleView = console2;
                    if (consoleView != null) {
                        consoleView.print("No code to verify\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                    return "";
                }
                errors = PsiErrorCollector.INSTANCE.collectSyntaxError(psiFile2, project);
                if (!(!((Collection)errors).isEmpty())) break block6;
                ConsoleView consoleView = console2;
                if (consoleView == null) break block7;
                consoleView.print("Syntax errors found:\n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                break block7;
            }
            ConsoleView consoleView = console2;
            if (consoleView == null) break block7;
            consoleView.print("No syntax errors found\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        return CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }
}

