/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/TimeMetricProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "startTime", "", "Ljava/lang/Long;", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "setup", "execute", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "", "devins-lang"})
public final class TimeMetricProcessor
implements PostProcessor {
    @Nullable
    private Long startTime;
    @NotNull
    private final String processorName = PostProcessorType.TimeMetric.getHandleName();
    @NotNull
    private final String description;

    public TimeMetricProcessor() {
        this.description = "`timeMetric` will calculate the time metric";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public String setup(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.startTime = System.currentTimeMillis();
        return String.valueOf(this.startTime);
    }

    @Override
    @NotNull
    public String execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        long endTime = System.currentTimeMillis();
        Long l = this.startTime;
        Intrinsics.checkNotNull((Object)l);
        return String.valueOf(endTime - l);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }
}

