/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.language.ShireConstants;
import cc.unitmesh.devti.language.middleware.builtin.SaveFileProcessorKt;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010!\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\""}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/SaveFileProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "", "getFileExt", "handleForTempFile", "", "fileName", "handleForProjectFile", "filepath", "getContent", "createFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectDir", "dispose", "devins-lang"})
public final class SaveFileProcessor
implements PostProcessor,
Disposable {
    @NotNull
    private final String processorName = PostProcessorType.SaveFile.getHandleName();
    @NotNull
    private final String description;

    public SaveFileProcessor() {
        this.description = "`saveFile` will save the content / llm response to the file";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public String execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Object fileName = null;
        String ext = this.getFileExt(context);
        if (!((Collection)args).isEmpty()) {
            fileName = SaveFileProcessorKt.getValidFilePath(args.get(0).toString(), ext);
            this.handleForProjectFile(project, (String)fileName, context, console2);
        } else {
            fileName = System.currentTimeMillis() + "." + ext;
            this.handleForTempFile(project, (String)fileName, context, console2);
        }
        return fileName;
    }

    private final String getFileExt(PostProcessorContext context) {
        Language language;
        String string;
        Language language2;
        Language language3 = context.getGenTargetLanguage();
        if (language3 == null) {
            language3 = language2 = (Language)PlainTextLanguage.INSTANCE;
        }
        if ((string = context.getGenTargetExtension()) == null && ((language = language2) != null && (language = language.getAssociatedFileType()) != null ? language.getDefaultExtension() : (string = null)) == null) {
            string = "txt";
        }
        return string;
    }

    private final void handleForTempFile(Project project, String fileName, PostProcessorContext context, ConsoleView console2) {
        ApplicationManager.getApplication().invokeAndWait(() -> SaveFileProcessor.handleForTempFile$lambda$1(project, this, fileName, context, console2));
    }

    private final void handleForProjectFile(Project project, String filepath, PostProcessorContext context, ConsoleView console2) {
        Ref.ObjectRef fileName = new Ref.ObjectRef();
        fileName.element = filepath;
        ApplicationManager.getApplication().invokeAndWait(() -> SaveFileProcessor.handleForProjectFile$lambda$3(project, fileName, this, context, console2));
    }

    private final String getContent(PostProcessorContext context) {
        Object outputData = context.getPipeData().get("output");
        if (outputData instanceof String && ((CharSequence)outputData).length() > 0) {
            return (String)outputData;
        }
        String string = context.getLastTaskOutput();
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            return context.getLastTaskOutput();
        }
        return context.getGenText();
    }

    private final VirtualFile createFile(String fileName, VirtualFile projectDir) {
        String[] stringArray = new String[]{"/"};
        List path = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
        String[] stringArray2 = new String[]{"/"};
        String name = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)fileName, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        VirtualFile parentDir = projectDir;
        for (String dir : path) {
            Object object = parentDir;
            if (object == null || (object = object.findChild(dir)) == null) {
                VirtualFile virtualFile = parentDir;
                object = virtualFile != null ? virtualFile.createChildDirectory((Object)this, dir) : null;
            }
            parentDir = object;
        }
        VirtualFile virtualFile = parentDir;
        if (virtualFile == null || (virtualFile = virtualFile.createChildData((Object)this, name)) == null) {
            throw new IllegalStateException("Failed to save file");
        }
        VirtualFile outputFile = virtualFile;
        return outputFile;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }

    private static final VirtualFile handleForTempFile$lambda$1$lambda$0(Project $project, SaveFileProcessor this$0, String $fileName, PostProcessorContext $context, ConsoleView $console) {
        VirtualFile outputFile;
        block7: {
            Object object;
            block6: {
                block5: {
                    VirtualFile outputDir = ShireConstants.INSTANCE.outputDir($project);
                    VirtualFile virtualFile = outputDir;
                    if (virtualFile == null || (virtualFile = virtualFile.createChildData((Object)this$0, $fileName)) == null) {
                        throw new IllegalStateException("Failed to save file, fileName: " + $fileName + ", outputDir: " + outputDir);
                    }
                    outputFile = virtualFile;
                    String content = this$0.getContent($context);
                    object = content;
                    if (object == null) break block5;
                    String string = object;
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = byArray;
                    if (byArray != null) break block6;
                }
                object = new byte[0];
            }
            outputFile.setBinaryContent((byte[])object);
            $context.getPipeData().put("output", outputFile);
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$project);
            if (virtualFile != null) {
                virtualFile.refresh(true, true);
            }
            ConsoleView consoleView = $console;
            if (consoleView == null) break block7;
            consoleView.print("Saved to " + outputFile.getCanonicalPath() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        return outputFile;
    }

    private static final void handleForTempFile$lambda$1(Project $project, SaveFileProcessor this$0, String $fileName, PostProcessorContext $context, ConsoleView $console) {
        WriteAction.compute(() -> SaveFileProcessor.handleForTempFile$lambda$1$lambda$0($project, this$0, $fileName, $context, $console));
    }

    private static final VirtualFile handleForProjectFile$lambda$3$lambda$2(Project $project, Ref.ObjectRef $fileName, SaveFileProcessor this$0, PostProcessorContext $context, ConsoleView $console) {
        VirtualFile outputFile;
        block9: {
            Object object;
            VirtualFile virtualFile;
            VirtualFile projectDir;
            block8: {
                block7: {
                    projectDir = ProjectUtil.guessProjectDir((Project)$project);
                    if (StringsKt.startsWith$default((String)((String)$fileName.element), (String)"/", (boolean)false, (int)2, null)) {
                        String projectPath;
                        VirtualFile virtualFile2 = projectDir;
                        String string = projectPath = virtualFile2 != null ? virtualFile2.getCanonicalPath() : null;
                        if (projectPath != null) {
                            $fileName.element = StringsKt.replace$default((String)((String)$fileName.element), (String)projectPath, (String)"", (boolean)false, (int)4, null);
                        }
                    }
                    VirtualFile virtualFile3 = projectDir;
                    VirtualFile virtualFile4 = outputFile = virtualFile3 != null ? virtualFile3.findFileByRelativePath((String)$fileName.element) : null;
                    if (outputFile == null) {
                        outputFile = this$0.createFile((String)$fileName.element, projectDir);
                    }
                    String content = this$0.getContent($context);
                    virtualFile = outputFile;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    object = content;
                    if (object == null) break block7;
                    String string = object;
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = byArray;
                    if (byArray != null) break block8;
                }
                object = new byte[0];
            }
            virtualFile.setBinaryContent((byte[])object);
            $context.getPipeData().put("output", outputFile);
            VirtualFile virtualFile5 = projectDir;
            if (virtualFile5 != null) {
                virtualFile5.refresh(true, true);
            }
            ConsoleView consoleView = $console;
            if (consoleView == null) break block9;
            consoleView.print("Saved to " + outputFile.getCanonicalPath(), ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        return outputFile;
    }

    private static final void handleForProjectFile$lambda$3(Project $project, Ref.ObjectRef $fileName, SaveFileProcessor this$0, PostProcessorContext $context, ConsoleView $console) {
        WriteAction.compute(() -> SaveFileProcessor.handleForProjectFile$lambda$3$lambda$2($project, $fileName, this$0, $context, $console));
    }
}

