/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.provider.RunService;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J*\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/RunCodeProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "", "doExecute", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "devins-lang"})
public final class RunCodeProcessor
implements PostProcessor {
    @NotNull
    private final String processorName = PostProcessorType.RunCode.getHandleName();
    @NotNull
    private final String description;

    public RunCodeProcessor() {
        this.description = "`runCode` will run the code, default will be test file.";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public String execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Object code = context.getPipeData().get("output");
            if (code instanceof VirtualFile) {
                LocalFileSystem.getInstance().refreshAndFindFileByPath(((VirtualFile)code).getPath());
                PsiFile psiFile2 = (PsiFile)ReadAction.compute(() -> RunCodeProcessor.execute$lambda$0(project, code));
                if (psiFile2 != null) {
                    PsiFile it = psiFile2;
                    boolean bl = false;
                    this.doExecute(console2, project, (VirtualFile)code, it);
                    return "";
                }
            } else if (code instanceof String) {
                Object object = context.getGenTargetLanguage();
                if (object == null || (object = object.getAssociatedFileType()) == null || (object = object.getDefaultExtension()) == null) {
                    object = "txt";
                }
                Object ext = object;
                ApplicationManager.getApplication().invokeAndWait(() -> RunCodeProcessor.execute$lambda$5(code, project, (String)ext, console2, this));
            }
            ConsoleView consoleView = console2;
            if (consoleView == null) break block5;
            consoleView.print("No code to run\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        return "";
    }

    private final void doExecute(ConsoleView console2, Project project, VirtualFile file, PsiFile psiFile2) {
        block8: {
            RunService fileRunService = RunService.Companion.provider(project, file);
            if (fileRunService == null) {
                String cliResult = RunService.Companion.runInCli$default(RunService.Companion, project, psiFile2, null, 4, null);
                if (cliResult != null) {
                    ConsoleView consoleView = console2;
                    if (consoleView != null) {
                        consoleView.print(cliResult, ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    return;
                }
                String string = RunService.Companion.retryRun$default(RunService.Companion, project, file, null, 4, null);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    ConsoleView consoleView = console2;
                    if (consoleView != null) {
                        consoleView.print(it, ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    return;
                }
                ConsoleView consoleView = console2;
                if (consoleView != null) {
                    consoleView.print("RunCode: No run service found for file: " + file + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                return;
            }
            ConsoleView consoleView = console2;
            if (consoleView != null) {
                consoleView.print("Running code...\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            String output = fileRunService.runFileAsync(project, file, (PsiElement)psiFile2);
            ConsoleView consoleView2 = console2;
            if (consoleView2 == null) break block8;
            String string = output;
            if (string == null) {
                string = "";
            }
            consoleView2.print(string, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }

    private static final PsiFile execute$lambda$0(Project $project, Object $code) {
        return PsiManager.getInstance((Project)$project).findFile((VirtualFile)$code);
    }

    private static final PsiFile execute$lambda$5$lambda$3(Project $project, VirtualFile $file) {
        return PsiManager.getInstance((Project)$project).findFile($file);
    }

    private static final void execute$lambda$5(Object $code, Project $project, String $ext, ConsoleView $console, RunCodeProcessor this$0) {
        block3: {
            PsiFile psiFile2;
            block1: {
                PsiFile psiFile3;
                block2: {
                    if (!StringsKt.contains$default((CharSequence)((CharSequence)$code), (CharSequence)"\n", (boolean)false, (int)2, null)) break block1;
                    psiFile3 = PsiFileFactory.getInstance((Project)$project).createFileFromText("temp." + $ext, (String)$code);
                    boolean bl = false;
                    if (psiFile3.getVirtualFile() != null) break block2;
                    ConsoleView consoleView = $console;
                    if (consoleView == null) break block3;
                    consoleView.print("Failed to create file for run\n", ConsoleViewContentType.ERROR_OUTPUT);
                    break block3;
                }
                VirtualFile virtualFile = psiFile3.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                Intrinsics.checkNotNull((Object)psiFile3);
                this$0.doExecute($console, $project, virtualFile, psiFile3);
                break block3;
            }
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath((String)$code);
            if (file == null) break block3;
            PsiFile psiFile4 = psiFile2 = (PsiFile)ReadAction.compute(() -> RunCodeProcessor.execute$lambda$5$lambda$3($project, file));
            if (psiFile4 != null) {
                PsiFile it = psiFile4;
                boolean bl = false;
                this$0.doExecute($console, $project, file, psiFile2);
            }
        }
    }
}

