/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/PatchProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nPatchProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchProcessor.kt\ncc/unitmesh/devti/language/middleware/builtin/PatchProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n*S KotlinDebug\n*F\n+ 1 PatchProcessor.kt\ncc/unitmesh/devti/language/middleware/builtin/PatchProcessor\n*L\n30#1:80\n30#1:81,3\n*E\n"})
public final class PatchProcessor
implements PostProcessor {
    @NotNull
    private final String processorName = PostProcessorType.Patch.getHandleName();
    @NotNull
    private final String description;

    public PatchProcessor() {
        this.description = "`patch` will apply the patch to the current file, default will use llm response.";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String argName = it.toString();
            if (StringsKt.startsWith$default((String)argName, (String)"$", (boolean)false, (int)2, null)) {
                if (Intrinsics.areEqual((Object)argName, (Object)"output") && context.getLastTaskOutput() != null) {
                    object = context.getLastTaskOutput();
                } else {
                    Map<String, Object> map = context.getCompiledVariables();
                    String string = argName.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    object = map.get(string);
                    if (object == null) {
                        object = "";
                    }
                }
            } else {
                object = it;
            }
            collection.add(object);
        }
        List args2 = (List)destination$iv$iv;
        if (args2.size() < 2) {
            ConsoleView consoleView = console2;
            if (consoleView != null) {
                consoleView.print("PatchProcessor: not enough arguments", ConsoleViewContentType.ERROR_OUTPUT);
            }
            return "";
        }
        String fileName = String.valueOf(args2.get(0));
        String content = String.valueOf(args2.get(1));
        ApplyPatchDefaultExecutor shelfExecutor = new ApplyPatchDefaultExecutor(project);
        PatchReader myReader = new PatchReader((CharSequence)content);
        myReader.parseAllPatches();
        List list = myReader.getAllPatches();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllPatches(...)");
        List filePatches = list;
        ApplicationManager.getApplication().invokeAndWait(() -> PatchProcessor.execute$lambda$1(project, filePatches, console2, myReader, shelfExecutor, fileName));
        String string = context.getGenText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }

    private static final void execute$lambda$1(Project $project, List $filePatches, ConsoleView $console, PatchReader $myReader, ApplyPatchDefaultExecutor $shelfExecutor, String $fileName) {
        List matchedPatches = new MatchPatchPaths($project).execute($filePatches, true);
        MultiMap patchGroups = new MultiMap();
        for (AbstractFilePatchInProgress patchInProgress : matchedPatches) {
            patchGroups.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
        }
        if ($filePatches.isEmpty()) {
            ConsoleView consoleView = $console;
            if (consoleView != null) {
                consoleView.print("PatchProcessor: no patches found", ConsoleViewContentType.ERROR_OUTPUT);
            }
            return;
        }
        ThrowableComputable throwableComputable = $myReader.getAdditionalInfo(ApplyPatchDefaultExecutor.pathsFromGroups((MultiMap)patchGroups));
        Intrinsics.checkNotNullExpressionValue((Object)throwableComputable, (String)"getAdditionalInfo(...)");
        ThrowableComputable additionalInfo = throwableComputable;
        $shelfExecutor.apply($filePatches, patchGroups, null, $fileName, additionalInfo);
    }
}

