/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.provider.PsiElementDataBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0015\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/ParseCommentProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "preHandleDoc", "Lorg/jetbrains/annotations/NonNls;", "newDoc", "buildDocFromSuggestion", "suggestDoc", "commentStart", "commentEnd", "getDocFromOutput", "execute", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "", "devins-lang"})
public final class ParseCommentProcessor
implements PostProcessor {
    @NotNull
    private final String processorName = PostProcessorType.ParseComment.getHandleName();
    @NotNull
    private final String description;

    public ParseCommentProcessor() {
        this.description = "`parseComment` will parse the comment from the llm response";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @NotNull
    public final String preHandleDoc(@NotNull String newDoc) {
        Intrinsics.checkNotNullParameter((Object)newDoc, (String)"newDoc");
        String newDocWithoutCodeBlock = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)newDoc, (CharSequence)"```java"), (CharSequence)"```"), (CharSequence)"```");
        String fromSuggestion = this.buildDocFromSuggestion(newDocWithoutCodeBlock, "/**", "*/");
        return fromSuggestion;
    }

    @NotNull
    public final String buildDocFromSuggestion(@NotNull String suggestDoc, @NotNull String commentStart, @NotNull String commentEnd) {
        Intrinsics.checkNotNullParameter((Object)suggestDoc, (String)"suggestDoc");
        Intrinsics.checkNotNullParameter((Object)commentStart, (String)"commentStart");
        Intrinsics.checkNotNullParameter((Object)commentEnd, (String)"commentEnd");
        int startIndex = StringsKt.indexOf$default((CharSequence)suggestDoc, (String)commentStart, (int)0, (boolean)false, (int)6, null);
        if (startIndex < 0) {
            return "";
        }
        String string = suggestDoc.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String docComment = string;
        int endIndex = StringsKt.indexOf$default((CharSequence)docComment, (String)commentEnd, (int)commentStart.length(), (boolean)false, (int)4, null);
        if (endIndex < 0) {
            return docComment + commentEnd;
        }
        String string2 = docComment.substring(0, endIndex + commentEnd.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String substring = string2;
        return substring;
    }

    private final String getDocFromOutput(PostProcessorContext context) {
        String string = (String)context.getPipeData().get("output");
        if (string == null && (string = context.getGenText()) == null) {
            string = "";
        }
        return this.preHandleDoc(string);
    }

    @Override
    @NotNull
    public String execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String defaultComment = this.getDocFromOutput(context);
        PsiFile psiFile2 = context.getCurrentFile();
        if (psiFile2 == null) {
            return defaultComment;
        }
        PsiFile currentFile = psiFile2;
        Language language = currentFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        PsiElementDataBuilder psiElementDataBuilder = PsiElementDataBuilder.Companion.forLanguage(language);
        if (psiElementDataBuilder == null || (string = psiElementDataBuilder.parseComment(project, defaultComment)) == null) {
            return defaultComment;
        }
        String comment = string;
        return comment;
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }
}

