/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/ParseCodeProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "", "devins-lang"})
public final class ParseCodeProcessor
implements PostProcessor {
    @NotNull
    private final String processorName = PostProcessorType.ParseCode.getHandleName();
    @NotNull
    private final String description;

    public ParseCodeProcessor() {
        this.description = "`parseCode` will parse the markdown from llm response.";
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public String execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String string = context.getGenText();
        if (string == null) {
            string = "";
        }
        CodeFence code = CodeFence.Companion.parse(string);
        String codeText = code.getText();
        context.setGenTargetLanguage(code.getLanguage());
        context.setGenTargetExtension(code.getExtension());
        context.getPipeData().put("output", codeText);
        context.getPipeData().put("code", codeText);
        return codeText;
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }
}

