/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.language.middleware.builtin.OpenWebpageProcessor;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserActionKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/OpenWebpageProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nOpenWebpageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenWebpageProcessor.kt\ncc/unitmesh/devti/language/middleware/builtin/OpenWebpageProcessor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n11#2:66\n*S KotlinDebug\n*F\n+ 1 OpenWebpageProcessor.kt\ncc/unitmesh/devti/language/middleware/builtin/OpenWebpageProcessor\n*L\n59#1:66\n*E\n"})
public final class OpenWebpageProcessor
implements PostProcessor {
    @Override
    @NotNull
    public String getProcessorName() {
        return PostProcessorType.OpenWebpage.getHandleName();
    }

    @Override
    @NotNull
    public String getDescription() {
        return "`openWebpage` will open the generated HTML in the browser";
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getGenText();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"<html", (boolean)false, (int)2, null) : false;
    }

    @Override
    @NotNull
    public Object execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        DataContext dataContext = (DataContext)DataManager.getInstance().getDataContextFromFocusAsync().blockingGet(10000);
        if (dataContext == null) {
            throw new IllegalStateException("No data context");
        }
        DataContext dataContext2 = dataContext;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            return "";
        }
        Editor editor2 = editor;
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (psiFile2 == null) {
            throw new IllegalStateException("No PSI file");
        }
        PsiFile psiFile3 = psiFile2;
        OpenInBrowserRequest request2 = new OpenInBrowserRequest(psiFile3, editor2){
            private final Lazy lazyElement$delegate;
            {
                this.lazyElement$delegate = LazyKt.lazy(() -> execute.request.1.lazyElement_delegate$lambda$0(this, $editor));
            }

            private final PsiElement getLazyElement() {
                Lazy lazy = this.lazyElement$delegate;
                return (PsiElement)lazy.getValue();
            }

            public PsiElement getElement() {
                PsiElement psiElement = this.getLazyElement();
                if (psiElement == null) {
                    psiElement = (PsiElement)this.getFile();
                }
                return psiElement;
            }

            private static final PsiElement lazyElement_delegate$lambda$0(execute.request.1 this$0, Editor $editor) {
                return this$0.getFile().findElementAt($editor.getCaretModel().getOffset());
            }
        };
        try {
            WebBrowser browser = OpenFileInDefaultBrowserActionKt.findUsingBrowser();
            Collection collection = WebBrowserService.getInstance().getUrlsToOpen(request2, true);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getUrlsToOpen(...)");
            Collection urls = collection;
            if (!urls.isEmpty()) {
                Url url = (Url)CollectionsKt.first((Iterable)urls);
                ActionsKt.runInEdt$default(null, OpenWebpageProcessor::execute$lambda$0, (int)1, null);
                BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
                String string = url.toExternalForm();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
                browserLauncher.browse(string, browser, request2.getProject());
            }
        }
        catch (WebBrowserUrlProvider.BrowserException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(OpenWebpageProcessor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        return "";
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }

    private static final Unit execute$lambda$0() {
        FileDocumentManager.getInstance().saveAllDocuments();
        return Unit.INSTANCE;
    }
}

