/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.middleware.builtin;

import cc.unitmesh.devti.devins.post.PostProcessor;
import cc.unitmesh.devti.devins.post.PostProcessorContext;
import cc.unitmesh.devti.devins.post.PostProcessorType;
import cc.unitmesh.devti.language.utils.ProjectFileUtilKt;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/language/middleware/builtin/DiffProcessor;", "Lcc/unitmesh/devti/devins/post/PostProcessor;", "<init>", "()V", "processorName", "", "getProcessorName", "()Ljava/lang/String;", "description", "getDescription", "diffFactory", "Lcom/intellij/diff/DiffContentFactoryEx;", "Lorg/jetbrains/annotations/NotNull;", "isApplicable", "", "context", "Lcc/unitmesh/devti/devins/post/PostProcessorContext;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "args", "", "devins-lang"})
public final class DiffProcessor
implements PostProcessor {
    @NotNull
    private final String processorName = PostProcessorType.Diff.getHandleName();
    @NotNull
    private final String description;
    @NotNull
    private final DiffContentFactoryEx diffFactory;

    public DiffProcessor() {
        this.description = "`diff` will show the diff of two texts, default is current code and llm response";
        DiffContentFactoryEx diffContentFactoryEx = DiffContentFactoryEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactoryEx, (String)"getInstanceEx(...)");
        this.diffFactory = diffContentFactoryEx;
    }

    @Override
    @NotNull
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isApplicable(@NotNull PostProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Override
    @NotNull
    public Object execute(@NotNull Project project, @NotNull PostProcessorContext context, @Nullable ConsoleView console2, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (args.size() < 2) {
            ConsoleView consoleView = console2;
            if (consoleView != null) {
                consoleView.print("DiffProcessor: not enough arguments", ConsoleViewContentType.ERROR_OUTPUT);
            }
            return "";
        }
        String firstArg = args.get(0).toString();
        VirtualFile virtualFile = (VirtualFile)ActionsKt.runReadAction(() -> DiffProcessor.execute$lambda$0(project, firstArg));
        if (virtualFile == null) {
            DiffProcessor it = this;
            boolean bl = false;
            ConsoleView consoleView = console2;
            if (consoleView != null) {
                consoleView.print("DiffProcessor: file not found", ConsoleViewContentType.ERROR_OUTPUT);
            }
            return "";
        }
        VirtualFile virtualFile2 = virtualFile;
        DiffContent diffContent = this.diffFactory.create(project, virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"create(...)");
        DiffContent currentDocContent = diffContent;
        DocumentContent documentContent = this.diffFactory.create(args.get(1).toString());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        DocumentContent newDocContent = documentContent;
        SimpleDiffRequest diffRequest = new SimpleDiffRequest("Shire Diff Viewer", currentDocContent, (DiffContent)newDocContent, "Current code", "AI generated");
        DiffRequestProducer diffRequestProducer = SimpleDiffRequestProducer.create((String)virtualFile2.getPath(), () -> DiffProcessor.execute$lambda$2(diffRequest));
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestProducer, (String)"create(...)");
        DiffRequestProducer producer = diffRequestProducer;
        SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer);
        ActionsKt.runInEdt$default(null, () -> DiffProcessor.execute$lambda$3(project, chain), (int)1, null);
        return "";
    }

    @Override
    @NotNull
    public Object setup(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.setup(this, context);
    }

    @Override
    @Nullable
    public Object finish(@NotNull PostProcessorContext context) {
        return PostProcessor.DefaultImpls.finish(this, context);
    }

    private static final VirtualFile execute$lambda$0(Project $project, String $firstArg) {
        return ProjectFileUtilKt.findFile$default($project, $firstArg, false, 2, null);
    }

    private static final DiffRequest execute$lambda$2(SimpleDiffRequest $diffRequest) {
        return (DiffRequest)$diffRequest;
    }

    private static final Unit execute$lambda$3(Project $project, SimpleDiffRequestChain $chain) {
        DiffManager.getInstance().showDiff($project, (DiffRequestChain)$chain, DiffDialogHints.FRAME);
        return Unit.INSTANCE;
    }
}

