/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.folding;

import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.psi.DevInCaseBody;
import cc.unitmesh.devti.language.psi.DevInCommandId;
import cc.unitmesh.devti.language.psi.DevInQueryStatement;
import cc.unitmesh.devti.language.psi.DevInTypes;
import cc.unitmesh.devti.language.psi.DevInUsed;
import cc.unitmesh.devti.language.psi.DevInVisitor;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/language/folding/DevInFoldingVisitor;", "Lcc/unitmesh/devti/language/psi/DevInVisitor;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "<init>", "(Ljava/util/List;)V", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitQueryStatement", "o", "Lcc/unitmesh/devti/language/psi/DevInQueryStatement;", "visitCaseBody", "Lcc/unitmesh/devti/language/psi/DevInCaseBody;", "devins-lang"})
public final class DevInFoldingVisitor
extends DevInVisitor {
    @NotNull
    private final List<FoldingDescriptor> descriptors;

    public DevInFoldingVisitor(@NotNull List<FoldingDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        this.descriptors = descriptors;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)element);
        if (Intrinsics.areEqual((Object)iElementType, (Object)DevInTypes.FRONT_MATTER_HEADER)) {
            this.descriptors.add(new FoldingDescriptor(element.getNode(), element.getTextRange()));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DevInTypes.CODE)) {
            this.descriptors.add(new FoldingDescriptor(element.getNode(), element.getTextRange()));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DevInTypes.USED)) {
            DevInCommandId commandId;
            DevInUsed devInUsed = element instanceof DevInUsed ? (DevInUsed)element : null;
            DevInCommandId devInCommandId = commandId = devInUsed != null ? devInUsed.getCommandId() : null;
            if (Intrinsics.areEqual((Object)(devInCommandId != null ? devInCommandId.getText() : null), (Object)BuiltinCommand.FILE.getCommandName())) {
                this.descriptors.add(new FoldingDescriptor(((DevInUsed)element).getNode(), ((DevInUsed)element).getTextRange()));
            }
        }
        element.acceptChildren((PsiElementVisitor)this);
    }

    @Override
    public void visitQueryStatement(@NotNull DevInQueryStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.descriptors.add(new FoldingDescriptor(o.getNode(), o.getTextRange()));
    }

    @Override
    public void visitCaseBody(@NotNull DevInCaseBody o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.descriptors.add(new FoldingDescriptor(o.getNode(), o.getTextRange()));
    }
}

