/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.debugger.editor;

import cc.unitmesh.devti.language.DevInFileType;
import cc.unitmesh.devti.language.debugger.editor.ShireFileEditorWithPreview;
import cc.unitmesh.devti.language.debugger.editor.ShirePreviewEditor;
import cc.unitmesh.devti.language.debugger.editor.ShirePreviewEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/language/debugger/editor/ShireSplitEditorProvider;", "Lcom/intellij/openapi/fileEditor/WeighedFileEditorProvider;", "<init>", "()V", "getEditorTypeId", "", "mainProvider", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "previewProvider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "devins-lang"})
public final class ShireSplitEditorProvider
extends WeighedFileEditorProvider {
    @NotNull
    private final TextEditorProvider mainProvider = TextEditorProvider.Companion.getInstance();
    @NotNull
    private final FileEditorProvider previewProvider = (FileEditorProvider)new ShirePreviewEditorProvider();

    @NotNull
    public String getEditorTypeId() {
        return "devin-split-editor";
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file, DevInFileType.Companion.getINSTANCE());
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditor editor = TextEditorProvider.Companion.getInstance().createEditor(project, file);
        if (editor.getFile() instanceof LightVirtualFile) {
            return editor;
        }
        FileEditor fileEditor2 = this.mainProvider.createEditor(project, file);
        Intrinsics.checkNotNull((Object)fileEditor2, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        TextEditor mainEditor = (TextEditor)fileEditor2;
        FileEditor fileEditor3 = this.previewProvider.createEditor(project, file);
        Intrinsics.checkNotNull((Object)fileEditor3, (String)"null cannot be cast to non-null type cc.unitmesh.devti.language.debugger.editor.ShirePreviewEditor");
        ShirePreviewEditor preview = (ShirePreviewEditor)fileEditor3;
        return (FileEditor)new ShireFileEditorWithPreview(mainEditor, preview, project);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_OTHER_EDITORS;
    }
}

