/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.debugger.editor;

import cc.unitmesh.devti.language.DevInBundle;
import cc.unitmesh.devti.language.debugger.snapshot.UserCustomVariableSnapshot;
import cc.unitmesh.devti.language.debugger.snapshot.VariableOperation;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/language/debugger/editor/ShireSnapshotViewPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "contentPanel", "Lcom/intellij/ui/components/JBPanel;", "tableModel", "Ljavax/swing/table/DefaultTableModel;", "setupPanel", "", "updateSnapshots", "snapshots", "", "Lcc/unitmesh/devti/language/debugger/snapshot/UserCustomVariableSnapshot;", "formatTimestamp", "", "timestamp", "", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nShireSnapshotViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShireSnapshotViewPanel.kt\ncc/unitmesh/devti/language/debugger/editor/ShireSnapshotViewPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1855#2,2:105\n*S KotlinDebug\n*F\n+ 1 ShireSnapshotViewPanel.kt\ncc/unitmesh/devti/language/debugger/editor/ShireSnapshotViewPanel\n*L\n80#1:105,2\n*E\n"})
public final class ShireSnapshotViewPanel
extends JPanel {
    @NotNull
    private final JBPanel<JBPanel<?>> contentPanel = new JBPanel((LayoutManager)new BorderLayout());
    @NotNull
    private final DefaultTableModel tableModel;

    public ShireSnapshotViewPanel() {
        super(new BorderLayout());
        JBScrollPane jBScrollPane;
        JBTable jBTable;
        Object[] objectArray = new String[]{"Variable", "Operation", "Value", "Timestamp"};
        this.tableModel = new DefaultTableModel(objectArray, 0);
        JBTable $this$_init__u24lambda_u240 = jBTable = new JBTable((TableModel)this.tableModel);
        boolean bl = false;
        $this$_init__u24lambda_u240.getTableHeader().setReorderingAllowed(true);
        $this$_init__u24lambda_u240.getTableHeader().setResizingAllowed(true);
        $this$_init__u24lambda_u240.setShowGrid(true);
        $this$_init__u24lambda_u240.setGridColor(JBColor.PanelBackground);
        $this$_init__u24lambda_u240.setIntercellSpacing((Dimension)JBUI.size((int)0, (int)0));
        TableColumnModel columnModel = $this$_init__u24lambda_u240.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(80);
        columnModel.getColumn(1).setPreferredWidth(60);
        columnModel.getColumn(2).setPreferredWidth(300);
        columnModel.getColumn(3).setPreferredWidth(80);
        $this$_init__u24lambda_u240.setAutoResizeMode(3);
        JBTable table = jBTable;
        JBScrollPane $this$_init__u24lambda_u241 = jBScrollPane = new JBScrollPane((Component)table, 20, 30);
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setMinimumSize((Dimension)JBUI.size((int)0, (int)160));
        $this$_init__u24lambda_u241.setPreferredSize((Dimension)JBUI.size((int)0, (int)160));
        JBScrollPane scrollPane = jBScrollPane;
        this.setupPanel();
        this.add((Component)scrollPane, "Center");
    }

    private final void setupPanel() {
        JBLabel jBLabel;
        this.contentPanel.setBackground((Color)new JBColor(0xF5F5F5, 2829616));
        JBLabel $this$setupPanel_u24lambda_u242 = jBLabel = new JBLabel(DevInBundle.message("editor.preview.variable.panel", new Object[0]));
        boolean bl = false;
        $this$setupPanel_u24lambda_u242.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        $this$setupPanel_u24lambda_u242.setFontColor(UIUtil.FontColor.BRIGHTER);
        $this$setupPanel_u24lambda_u242.setBackground((Color)new JBColor(0xF5F5F5, 2829616));
        $this$setupPanel_u24lambda_u242.setFont((Font)JBUI.Fonts.label((float)14.0f).asBold());
        $this$setupPanel_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)0, (int)16));
        $this$setupPanel_u24lambda_u242.setOpaque(true);
        JBLabel titleLabel = jBLabel;
        this.contentPanel.add((Component)titleLabel, (Object)"North");
        this.add((Component)this.contentPanel, "North");
    }

    public final void updateSnapshots(@NotNull List<UserCustomVariableSnapshot> snapshots) {
        Intrinsics.checkNotNullParameter(snapshots, (String)"snapshots");
        if (snapshots.isEmpty()) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.tableModel.setRowCount(0);
        this.tableModel.getDataVector().removeAllElements();
        Iterable $this$forEach$iv = snapshots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserCustomVariableSnapshot snapshot = (UserCustomVariableSnapshot)((Object)element$iv);
            boolean bl = false;
            VariableOperation operation = (VariableOperation)CollectionsKt.firstOrNull(snapshot.getOperations());
            Object[] objectArray = new String[4];
            objectArray[0] = snapshot.getVariableName();
            Object object = operation;
            if (object == null || (object = ((VariableOperation)object).getFunctionName()) == null) {
                object = "";
            }
            objectArray[1] = object;
            objectArray[2] = String.valueOf(snapshot.getValue());
            VariableOperation variableOperation = operation;
            objectArray[3] = this.formatTimestamp(variableOperation != null ? variableOperation.getTimestamp() : 0L);
            this.tableModel.addRow(objectArray);
        }
        this.revalidate();
        this.repaint();
    }

    private final String formatTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return "N/A";
        }
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timestamp);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

