/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.debugger;

import cc.unitmesh.devti.language.debugger.ShireDebugEvaluator;
import cc.unitmesh.devti.language.debugger.ShireDebugProcess;
import cc.unitmesh.devti.language.debugger.ShireDebugValue;
import cc.unitmesh.devti.language.debugger.snapshot.UserCustomVariableSnapshot;
import cc.unitmesh.devti.language.debugger.snapshot.VariableOperation;
import cc.unitmesh.devti.language.run.runner.ShireRunnerContext;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/language/debugger/ShireStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Lcom/intellij/openapi/Disposable;", "process", "Lcc/unitmesh/devti/language/debugger/ShireDebugProcess;", "project", "Lcom/intellij/openapi/project/Project;", "snapshot", "Lcc/unitmesh/devti/language/debugger/snapshot/UserCustomVariableSnapshot;", "<init>", "(Lcc/unitmesh/devti/language/debugger/ShireDebugProcess;Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/language/debugger/snapshot/UserCustomVariableSnapshot;)V", "getProcess", "()Lcc/unitmesh/devti/language/debugger/ShireDebugProcess;", "getProject", "()Lcom/intellij/openapi/project/Project;", "snapshotValue", "Lcc/unitmesh/devti/language/debugger/ShireDebugValue;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "computeChildren", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "dispose", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nShireStackFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShireStackFrame.kt\ncc/unitmesh/devti/language/debugger/ShireStackFrame\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,133:1\n215#2,2:134\n*S KotlinDebug\n*F\n+ 1 ShireStackFrame.kt\ncc/unitmesh/devti/language/debugger/ShireStackFrame\n*L\n80#1:134,2\n*E\n"})
public final class ShireStackFrame
extends XStackFrame
implements Disposable {
    @NotNull
    private final ShireDebugProcess process;
    @NotNull
    private final Project project;
    @Nullable
    private final UserCustomVariableSnapshot snapshot;
    @Nullable
    private ShireDebugValue snapshotValue;

    public ShireStackFrame(@NotNull ShireDebugProcess process2, @NotNull Project project, @Nullable UserCustomVariableSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)((Object)process2), (String)"process");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.process = process2;
        this.project = project;
        this.snapshot = snapshot;
    }

    public /* synthetic */ ShireStackFrame(ShireDebugProcess shireDebugProcess, Project project, UserCustomVariableSnapshot userCustomVariableSnapshot, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            userCustomVariableSnapshot = null;
        }
        this(shireDebugProcess, project, userCustomVariableSnapshot);
    }

    @NotNull
    public final ShireDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.snapshot == null) {
            component2.append("Init", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component2.setIcon(AllIcons.Debugger.Frame);
            return;
        }
        VariableOperation variableOperation = (VariableOperation)CollectionsKt.firstOrNull(this.snapshot.getOperations());
        if (variableOperation == null) {
            component2.append(this.snapshot.getVariableName() + " -> Init()", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            component2.setIcon(AllIcons.Debugger.Frame);
        } else {
            String functionName = variableOperation.getFunctionName();
            String value = String.valueOf(variableOperation.getValue());
            this.snapshotValue = new ShireDebugValue(this.snapshot.getVariableName(), "String", value, this.snapshot);
            component2.append(this.snapshot.getVariableName() + " -> " + functionName + "(" + value + ")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            component2.setIcon(AllIcons.Debugger.Frame);
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        XValueChildrenList root = new XValueChildrenList();
        ShireDebugValue shireDebugValue = this.snapshotValue;
        if (shireDebugValue != null) {
            ShireDebugValue it = shireDebugValue;
            boolean bl = false;
            root.add((XNamedValue)it);
        }
        node.addChildren(root, false);
        XValueChildrenList filteredChildren = new XValueChildrenList();
        Object object = this.process.getShireRunnerContext();
        if (object != null && (object = ((ShireRunnerContext)object).getCompiledVariables()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                filteredChildren.add((XNamedValue)new ShireDebugValue((String)it.getKey(), "String", it.getValue().toString(), null, 8, null));
            }
        }
        node.addChildren(filteredChildren, true);
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        return new ShireDebugEvaluator();
    }

    public void dispose() {
    }
}

