/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.streaming;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.language.compiler.streaming.StreamingServiceProvider;
import cc.unitmesh.devti.language.console.DevInConsoleViewBase;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/language/compiler/streaming/TimingStreamingService;", "Lcc/unitmesh/devti/language/compiler/streaming/StreamingServiceProvider;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "time", "", "console", "Lcc/unitmesh/devti/language/console/DevInConsoleViewBase;", "onCreated", "", "afterStreamingDone", "project", "Lcom/intellij/openapi/project/Project;", "devins-lang"})
public final class TimingStreamingService
implements StreamingServiceProvider {
    @NotNull
    private String name = "timing";
    private long time;
    @Nullable
    private DevInConsoleViewBase console;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    public void onCreated(@Nullable DevInConsoleViewBase console2) {
        block1: {
            long currentTime;
            this.console = console2;
            this.time = currentTime = System.currentTimeMillis();
            DevInConsoleViewBase devInConsoleViewBase = console2;
            if (devInConsoleViewBase != null) {
                devInConsoleViewBase.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            DevInConsoleViewBase devInConsoleViewBase2 = console2;
            if (devInConsoleViewBase2 == null) break block1;
            devInConsoleViewBase2.print("Start timing: " + currentTime + " \n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @Override
    public void afterStreamingDone(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        long currentTime = System.currentTimeMillis();
        DevInConsoleViewBase devInConsoleViewBase = this.console;
        if (devInConsoleViewBase != null) {
            devInConsoleViewBase.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        DevInConsoleViewBase devInConsoleViewBase2 = this.console;
        if (devInConsoleViewBase2 != null) {
            devInConsoleViewBase2.print("End timing: " + currentTime + " \n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        AutoDevNotifications.INSTANCE.warn(project, "Timing: " + (currentTime - this.time) + "ms");
    }

    @Override
    public void onBeforeStreaming(@NotNull Project project, @NotNull String userPrompt, @Nullable DevInConsoleViewBase console2) {
        StreamingServiceProvider.DefaultImpls.onBeforeStreaming(this, project, userPrompt, console2);
    }

    @Override
    public void onStreaming(@NotNull Project project, @NotNull String flow, @NotNull List<? extends Object> args) {
        StreamingServiceProvider.DefaultImpls.onStreaming(this, project, flow, args);
    }

    @Override
    public void dispose() {
        StreamingServiceProvider.DefaultImpls.dispose(this);
    }
}

