/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.streaming;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.language.compiler.streaming.StreamingServiceProvider;
import cc.unitmesh.devti.language.console.DevInConsoleViewBase;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/language/compiler/streaming/ProfilingStreamingService;", "Lcc/unitmesh/devti/language/compiler/streaming/StreamingServiceProvider;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "console", "Lcc/unitmesh/devti/language/console/DevInConsoleViewBase;", "onBeforeStreaming", "", "project", "Lcom/intellij/openapi/project/Project;", "userPrompt", "afterStreamingDone", "getMemory", "", "toMb", "value", "devins-lang"})
public final class ProfilingStreamingService
implements StreamingServiceProvider {
    @NotNull
    private String name = "profiling";
    @Nullable
    private DevInConsoleViewBase console;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    public void onBeforeStreaming(@NotNull Project project, @NotNull String userPrompt, @Nullable DevInConsoleViewBase console2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
            this.console = console2;
            DevInConsoleViewBase devInConsoleViewBase = console2;
            if (devInConsoleViewBase == null) break block0;
            devInConsoleViewBase.print("Start profiling: " + this.getMemory(), ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @Override
    public void afterStreamingDone(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DevInConsoleViewBase devInConsoleViewBase = this.console;
        if (devInConsoleViewBase != null) {
            devInConsoleViewBase.print("End profiling: " + this.getMemory(), ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        AutoDevNotifications.INSTANCE.warn(project, "Memory: " + this.getMemory() + "MB");
    }

    private final long getMemory() {
        Runtime runtime = Runtime.getRuntime();
        long allocatedMem = runtime.totalMemory();
        long usedMem = allocatedMem - runtime.freeMemory();
        return this.toMb(usedMem);
    }

    private final long toMb(long value) {
        return value / (long)0x100000;
    }

    @Override
    public void onCreated(@Nullable DevInConsoleViewBase console2) {
        StreamingServiceProvider.DefaultImpls.onCreated(this, console2);
    }

    @Override
    public void onStreaming(@NotNull Project project, @NotNull String flow, @NotNull List<? extends Object> args) {
        StreamingServiceProvider.DefaultImpls.onStreaming(this, project, flow, args);
    }

    @Override
    public void dispose() {
        StreamingServiceProvider.DefaultImpls.dispose(this);
    }
}

