/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.streaming;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.devins.post.LifecycleProcessorSignature;
import cc.unitmesh.devti.language.compiler.streaming.StreamingServiceProvider;
import cc.unitmesh.devti.language.console.DevInConsoleViewBase;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0011J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001aJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/language/compiler/streaming/OnStreamingService;", "", "<init>", "()V", "map", "", "Lcc/unitmesh/devti/devins/post/LifecycleProcessorSignature;", "Lcc/unitmesh/devti/language/compiler/streaming/StreamingServiceProvider;", "getMap", "()Ljava/util/Map;", "console", "Lcc/unitmesh/devti/language/console/DevInConsoleViewBase;", "getConsole", "()Lcc/unitmesh/devti/language/console/DevInConsoleViewBase;", "setConsole", "(Lcc/unitmesh/devti/language/console/DevInConsoleViewBase;)V", "registerStreamingService", "", "sign", "clearStreamingService", "all", "", "onStart", "project", "Lcom/intellij/openapi/project/Project;", "userPrompt", "", "onStreaming", "chunk", "onDone", "onStreamingError", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nOnStreamingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnStreamingService.kt\ncc/unitmesh/devti/language/compiler/streaming/OnStreamingService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,76:1\n215#2,2:77\n215#2,2:79\n215#2,2:81\n*S KotlinDebug\n*F\n+ 1 OnStreamingService.kt\ncc/unitmesh/devti/language/compiler/streaming/OnStreamingService\n*L\n42#1:77,2\n52#1:79,2\n63#1:81,2\n*E\n"})
public final class OnStreamingService {
    @NotNull
    private final Map<LifecycleProcessorSignature, StreamingServiceProvider> map = new LinkedHashMap();
    @Nullable
    private DevInConsoleViewBase console;

    @NotNull
    public final Map<LifecycleProcessorSignature, StreamingServiceProvider> getMap() {
        return this.map;
    }

    @Nullable
    public final DevInConsoleViewBase getConsole() {
        return this.console;
    }

    public final void setConsole(@Nullable DevInConsoleViewBase devInConsoleViewBase) {
        this.console = devInConsoleViewBase;
    }

    public final void registerStreamingService(@NotNull LifecycleProcessorSignature sign, @Nullable DevInConsoleViewBase console2) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        this.console = console2;
        StreamingServiceProvider streamingService = StreamingServiceProvider.Companion.getStreamingService(sign.getFuncName());
        if (streamingService != null) {
            this.map.put(sign, streamingService);
            streamingService.onCreated(console2);
        }
    }

    public final void clearStreamingService() {
        this.map.clear();
    }

    @NotNull
    public final List<StreamingServiceProvider> all() {
        return StreamingServiceProvider.Companion.all();
    }

    public final void onStart(@NotNull Project project, @NotNull String userPrompt) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
        Map<LifecycleProcessorSignature, StreamingServiceProvider> $this$forEach$iv = this.map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider> element$iv;
            Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider> entry = element$iv = iterator.next();
            boolean bl = false;
            StreamingServiceProvider service = entry.getValue();
            try {
                service.onBeforeStreaming(project, userPrompt, this.console);
            }
            catch (Exception e) {
                AutoDevNotifications.INSTANCE.error(project, "Error on start streaming service: " + e.getMessage());
            }
        }
    }

    public final void onStreaming(@NotNull Project project, @NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Map<LifecycleProcessorSignature, StreamingServiceProvider> $this$forEach$iv = this.map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider> element$iv;
            Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider> entry = element$iv = iterator.next();
            boolean bl = false;
            LifecycleProcessorSignature sign = entry.getKey();
            StreamingServiceProvider service = entry.getValue();
            try {
                service.onStreaming(project, chunk, sign.getArgs());
            }
            catch (Exception e) {
                AutoDevNotifications.INSTANCE.error(project, "Error on streaming service: " + e.getMessage());
            }
        }
    }

    public final void onDone(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map<LifecycleProcessorSignature, StreamingServiceProvider> $this$forEach$iv = this.map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider> element$iv;
            Map.Entry<LifecycleProcessorSignature, StreamingServiceProvider> entry = element$iv = iterator.next();
            boolean bl = false;
            StreamingServiceProvider service = entry.getValue();
            try {
                service.afterStreamingDone(project);
            }
            catch (Exception e) {
                AutoDevNotifications.INSTANCE.error(project, "Error on done streaming service: " + e.getMessage());
            }
        }
    }

    public final void onStreamingError() {
    }
}

