/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.service;

import cc.unitmesh.devti.provider.RunService;
import cc.unitmesh.devti.sketch.run.ProcessExecutor;
import cc.unitmesh.devti.sketch.run.ProcessExecutorResult;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunner;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/language/compiler/service/ShellRunService;", "Lcc/unitmesh/devti/provider/RunService;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runFile", "", "virtualFile", "psiElement", "Lcom/intellij/psi/PsiElement;", "isFromToolAction", "runConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/RunProfile;", "createConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "devins-lang"})
public final class ShellRunService
implements RunService {
    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"sh") || Intrinsics.areEqual((Object)file.getExtension(), (Object)"bash");
    }

    @Override
    @Nullable
    public String runFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean isFromToolAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = project.getBasePath();
        if (string == null) {
            return "Project base path not found";
        }
        String workingDirectory = string;
        String code = SingleFileDiffSketchKt.readText(virtualFile);
        if (isFromToolAction) {
            ProcessExecutorResult result = new ProcessExecutor(project).executeCode(code);
            boolean bl = false;
            return result.getExitCode() != 0 ? "Error: " + result.getErrOutput() : "Output: " + result.getStdOutput();
        }
        ShRunner shRunner = (ShRunner)ApplicationManager.getApplication().getService(ShRunner.class);
        if (shRunner == null) {
            return "Shell runner not found";
        }
        ShRunner shRunner2 = shRunner;
        if (shRunner2.isAvailable(project)) {
            shRunner2.run(project, virtualFile.getPath(), workingDirectory, "Shell Run Service", true);
        }
        return "Running shell command: " + virtualFile.getPath();
    }

    @Override
    @NotNull
    public Class<? extends RunProfile> runConfigurationClass(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ShRunConfiguration.class;
    }

    @Override
    @Nullable
    public RunConfiguration createConfiguration(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ShFile shFile = (ShFile)ActionsKt.runReadAction(() -> ShellRunService.createConfiguration$lambda$1(project, virtualFile));
        if (shFile == null) {
            return null;
        }
        ShFile psiFile2 = shFile;
        RunManager runManager = RunManager.Companion.getInstance(project);
        String string = psiFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ShConfigurationType shConfigurationType = ShConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)shConfigurationType, (String)"getInstance(...)");
        RunnerAndConfigurationSettings configurationSetting = runManager.createConfiguration(string, (ConfigurationFactory)shConfigurationType);
        RunConfiguration runConfiguration = configurationSetting.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.sh.run.ShRunConfiguration");
        ShRunConfiguration configuration = (ShRunConfiguration)runConfiguration;
        String string2 = project.getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        configuration.setScriptWorkingDirectory(string2);
        configuration.setScriptPath(virtualFile.getPath());
        return configurationSetting.getConfiguration();
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createRunSettings(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.createRunSettings(this, project, virtualFile, psiElement);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createDefaultConfigurations(@NotNull Project project, @NotNull PsiElement element) {
        return RunService.DefaultImpls.createDefaultConfigurations(this, project, element);
    }

    @Override
    @NotNull
    public List<String> collectPsiError(@NotNull PsiFile $this$collectPsiError) {
        return RunService.DefaultImpls.collectPsiError(this, $this$collectPsiError);
    }

    @Override
    @Nullable
    public String runFileAsync(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.runFileAsync(this, project, virtualFile, psiElement);
    }

    private static final ShFile createConfiguration$lambda$1(Project $project, VirtualFile $virtualFile) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)$project).findFile($virtualFile);
        return psiFile2 instanceof ShFile ? (ShFile)psiFile2 : null;
    }
}

