/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.service;

import cc.unitmesh.devti.language.run.DevInsConfiguration;
import cc.unitmesh.devti.language.run.runner.ShireConsoleView;
import cc.unitmesh.devti.language.status.DevInsRunListener;
import cc.unitmesh.devti.provider.RunService;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J$\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/language/compiler/service/DevInRunService;", "Lcc/unitmesh/devti/provider/RunService;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/RunProfile;", "runFile", "", "virtualFile", "psiElement", "Lcom/intellij/psi/PsiElement;", "isFromToolAction", "asyncRunFile", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nDevInRunService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevInRunService.kt\ncc/unitmesh/devti/language/compiler/service/DevInRunService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n11#2:91\n*S KotlinDebug\n*F\n+ 1 DevInRunService.kt\ncc/unitmesh/devti/language/compiler/service/DevInRunService\n*L\n56#1:91\n*E\n"})
public final class DevInRunService
implements RunService {
    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"devin");
    }

    @Override
    @NotNull
    public Class<? extends RunProfile> runConfigurationClass(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DevInsConfiguration.class;
    }

    @Override
    @Nullable
    public String runFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean isFromToolAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createRunSettings(project, virtualFile, psiElement);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type cc.unitmesh.devti.language.run.DevInsConfiguration");
        DevInsConfiguration runConfiguration2 = (DevInsConfiguration)runConfiguration;
        runConfiguration2.setShowConsole(!isFromToolAction);
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        runConfiguration2.setScriptPath(string);
        Executor executorInstance = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNull((Object)executorInstance);
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = ExecutionEnvironmentBuilder.Companion.createOrNull(executorInstance, (RunConfiguration)runConfiguration2);
        if (executionEnvironmentBuilder == null) {
            return null;
        }
        ExecutionEnvironmentBuilder builder = executionEnvironmentBuilder;
        ExecutionManager.Companion.getInstance(project).restartRunProfile(ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder, null, (int)1, null));
        return "Running DevIn file: " + virtualFile.getName();
    }

    private final String asyncRunFile(Project project, VirtualFile virtualFile, PsiElement psiElement) {
        ExecutionEnvironment executionEnvironment;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createRunSettings(project, virtualFile, psiElement);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type cc.unitmesh.devti.language.run.DevInsConfiguration");
        DevInsConfiguration runConfiguration2 = (DevInsConfiguration)runConfiguration;
        Executor executorInstance = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNull((Object)executorInstance);
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = ExecutionEnvironmentBuilder.Companion.createOrNull(executorInstance, (RunConfiguration)runConfiguration2);
        ExecutionEnvironment executionEnvironment2 = executionEnvironment = executionEnvironmentBuilder != null ? ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder, null, (int)1, null) : null;
        if (executionEnvironment == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DevInRunService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to create execution environment");
            return null;
        }
        CompletableFuture<String> future = new CompletableFuture<String>();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable hintDisposable = disposable;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(hintDisposable);
        connection.subscribe(DevInsRunListener.Companion.getTOPIC(), (Object)new DevInsRunListener(future, connection, hintDisposable){
            final /* synthetic */ CompletableFuture<String> $future;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Disposable $hintDisposable;
            {
                this.$future = $future;
                this.$connection = $connection;
                this.$hintDisposable = $hintDisposable;
            }

            public void runFinish(String string, String llmOutput, ProcessEvent event, String scriptPath, ShireConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                Intrinsics.checkNotNullParameter((Object)llmOutput, (String)"llmOutput");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
                this.$future.complete(string);
                this.$connection.disconnect();
                Disposer.dispose((Disposable)this.$hintDisposable);
            }
        });
        ExecutionManager executionManager = ExecutionManager.Companion.getInstance(project);
        ExecutionTarget executionTarget = executionEnvironment.getExecutionTarget();
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"getExecutionTarget(...)");
        executionManager.restartRunProfile(project, executorInstance, executionTarget, settings, null);
        return future.get();
    }

    @Override
    @Nullable
    public RunConfiguration createConfiguration(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        return RunService.DefaultImpls.createConfiguration(this, project, virtualFile);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createRunSettings(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.createRunSettings(this, project, virtualFile, psiElement);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings createDefaultConfigurations(@NotNull Project project, @NotNull PsiElement element) {
        return RunService.DefaultImpls.createDefaultConfigurations(this, project, element);
    }

    @Override
    @NotNull
    public List<String> collectPsiError(@NotNull PsiFile $this$collectPsiError) {
        return RunService.DefaultImpls.collectPsiError(this, $this$collectPsiError);
    }

    @Override
    @Nullable
    public String runFileAsync(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement) {
        return RunService.DefaultImpls.runFileAsync(this, project, virtualFile, psiElement);
    }
}

