/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.searcher;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcc/unitmesh/devti/language/compiler/searcher/PatternSearcher;", "", "<init>", "()V", "cache", "", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFilesByRegex", "project", "Lcom/intellij/openapi/project/Project;", "regex", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nPatternSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternSearcher.kt\ncc/unitmesh/devti/language/compiler/searcher/PatternSearcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n11#2:61\n*S KotlinDebug\n*F\n+ 1 PatternSearcher.kt\ncc/unitmesh/devti/language/compiler/searcher/PatternSearcher\n*L\n38#1:61\n*E\n"})
public final class PatternSearcher {
    @NotNull
    public static final PatternSearcher INSTANCE = new PatternSearcher();
    @NotNull
    private static final Map<String, List<VirtualFile>> cache = new LinkedHashMap();

    private PatternSearcher() {
    }

    @NotNull
    public final List<VirtualFile> findFilesByRegex(@NotNull Project project, @NotNull String regex) {
        Pattern pattern;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        if (cache.containsKey(regex)) {
            List<VirtualFile> list = cache.get(regex);
            Intrinsics.checkNotNull(list);
            return list;
        }
        try {
            pattern = Pattern.compile(regex);
            Intrinsics.checkNotNull((Object)pattern);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PatternSearcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Invalid regex: " + regex);
            return CollectionsKt.emptyList();
        }
        Pattern pattern2 = pattern;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile baseDir = virtualFile;
        List matchingFiles = new ArrayList();
        VirtualFileManager.getInstance().getFileSystem("file").refresh(false);
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)baseDir, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(pattern2, (List<VirtualFile>)matchingFiles, optionArray){
            final /* synthetic */ Pattern $pattern;
            final /* synthetic */ List<VirtualFile> $matchingFiles;
            {
                this.$pattern = $pattern;
                this.$matchingFiles = $matchingFiles;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (this.$pattern.matcher(file.getName()).matches()) {
                    this.$matchingFiles.add(file);
                }
                return true;
            }
        }));
        return matchingFiles;
    }
}

