/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.processor;

import cc.unitmesh.devti.custom.compile.VariableTemplateCompiler;
import cc.unitmesh.devti.language.ast.variable.VariableTable;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import cc.unitmesh.devti.language.compiler.processor.CompilerContext;
import cc.unitmesh.devti.language.compiler.processor.ProcessResult;
import cc.unitmesh.devti.language.psi.DevInTypes;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcc/unitmesh/devti/language/compiler/processor/VariableProcessor;", "", "<init>", "()V", "processVariable", "Lcc/unitmesh/devti/language/compiler/processor/ProcessResult;", "variableStart", "Lcom/intellij/psi/PsiElement;", "context", "Lcc/unitmesh/devti/language/compiler/processor/CompilerContext;", "devins-lang"})
public final class VariableProcessor {
    @NotNull
    public final ProcessResult processVariable(@NotNull PsiElement variableStart, @NotNull CompilerContext context) {
        int n;
        PsiElement currentElement;
        PsiElement psiElement;
        Editor currentEditor;
        Intrinsics.checkNotNullParameter((Object)variableStart, (String)"variableStart");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)variableStart), (Object)DevInTypes.VARIABLE_START)) {
            context.getLogger().warn("Illegal type: " + PsiTreeUtilKt.getElementType((PsiElement)variableStart));
            return new ProcessResult(false, "Illegal variable start type", false, 4, null);
        }
        String variableId = (String)ActionsKt.runReadAction(() -> VariableProcessor.processVariable$lambda$0(variableStart));
        Editor editor = context.getEditor();
        if (editor == null) {
            editor = currentEditor = VariableTemplateCompiler.Companion.defaultEditor(context.getProject());
        }
        if ((psiElement = context.getElement()) == null) {
            psiElement = VariableTemplateCompiler.Companion.defaultElement(context.getProject(), currentEditor);
        }
        if ((currentElement = psiElement) == null) {
            String errorMsg = DevInErrorKt.getDEVINS_ERROR() + " No element found for variable: " + variableStart.getText();
            context.appendOutput(errorMsg);
            context.setError(true);
            return new ProcessResult(false, errorMsg, false, 4, null);
        }
        try {
            n = ((Number)ActionsKt.runReadAction(() -> VariableProcessor.processVariable$lambda$1(currentElement, variableStart))).intValue();
        }
        catch (Exception e) {
            n = 0;
        }
        int lineNo = n;
        VariableTable variableTable = context.getVariableTable();
        String string = variableId;
        if (string == null) {
            string = "";
        }
        VariableTable.addVariable$default(variableTable, string, VariableTable.VariableType.String, lineNo, null, 8, null);
        return new ProcessResult(true, null, false, 6, null);
    }

    private static final String processVariable$lambda$0(PsiElement $variableStart) {
        PsiElement psiElement = $variableStart.getNextSibling();
        return psiElement != null ? psiElement.getText() : null;
    }

    private static final int processVariable$lambda$1(PsiElement $currentElement, PsiElement $variableStart) {
        Document document;
        PsiFile containingFile = $currentElement.getContainingFile();
        Document document2 = document = PsiDocumentManager.getInstance((Project)$variableStart.getProject()).getDocument(containingFile);
        return document2 != null ? document2.getLineNumber($variableStart.getTextRange().getStartOffset()) : 0;
    }
}

