/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.vcs;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.git.GitUtil;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/vcs/CommitInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "commitMsg", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getCommitMsg", "()Ljava/lang/String;", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeShelveChangesAction", "", "devins-lang"})
public final class CommitInsCommand
implements InsCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String commitMsg;
    @NotNull
    private final BuiltinCommand commandName;

    public CommitInsCommand(@NotNull Project myProject, @NotNull String commitMsg) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)commitMsg, (String)"commitMsg");
        this.myProject = myProject;
        this.commitMsg = commitMsg;
        this.commandName = BuiltinCommand.COMMIT;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final String getCommitMsg() {
        return this.commitMsg;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        if (AutoSketchMode.Companion.getInstance(this.myProject).isEnable()) {
            this.invokeShelveChangesAction();
            return "Commit by UI will depends by user selection";
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList changeList = localChangeList;
        GitUtil.INSTANCE.doCommit(this.myProject, changeList, this.commitMsg);
        return "Commited for " + changeList;
    }

    private final void invokeShelveChangesAction() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction shelveAction = actionManager.getAction("ChangesView.Shelve");
        if (shelveAction != null) {
            ApplicationManager.getApplication().invokeLater(() -> CommitInsCommand.invokeShelveChangesAction$lambda$0(shelveAction), ModalityState.NON_MODAL);
        }
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final void invokeShelveChangesAction$lambda$0(AnAction $shelveAction) {
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)$shelveAction, null, (String)"", (DataContext)dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent event = anActionEvent;
        $shelveAction.actionPerformed(event);
    }
}

