/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.process;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.process.ProcessInfo;
import cc.unitmesh.devti.process.ProcessStateManager;
import cc.unitmesh.devti.process.ProcessStatus;
import cc.unitmesh.devti.process.WriteProcessInputResponse;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/process/WriteProcessInputInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "codeContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseParameters", "Lkotlin/Pair;", "", "extractInputFromProp", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nWriteProcessInputInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteProcessInputInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/WriteProcessInputInsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1747#2,3:83\n766#2:86\n857#2,2:87\n*S KotlinDebug\n*F\n+ 1 WriteProcessInputInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/WriteProcessInputInsCommand\n*L\n66#1:83,3\n76#1:86\n76#1:87,2\n*E\n"})
public final class WriteProcessInputInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @Nullable
    private final String codeContent;
    @NotNull
    private final BuiltinCommand commandName;

    public WriteProcessInputInsCommand(@NotNull Project project, @NotNull String prop, @Nullable String codeContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        this.project = project;
        this.prop = prop;
        this.codeContent = codeContent;
        this.commandName = BuiltinCommand.WRITE_PROCESS_INPUT;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        String string;
        String inputData;
        ProcessStateManager processStateManager = ProcessStateManager.Companion.getInstance(this.project);
        Pair<String, Boolean> pair = this.parseParameters(this.prop);
        String processId = (String)pair.component1();
        boolean appendNewline = (Boolean)pair.component2();
        if (((CharSequence)processId).length() == 0) {
            return "Error: Process ID is required. Usage: /write-process-input:process_id [--no-newline]";
        }
        String string2 = this.codeContent;
        if (string2 == null) {
            string2 = this.extractInputFromProp(this.prop);
        }
        if (((CharSequence)(inputData = string2)).length() == 0) {
            return "Error: No input data provided. Please provide input data in a code block or after the process ID.";
        }
        ProcessInfo processInfo = processStateManager.getProcess(processId);
        if (processInfo == null) {
            return "Error: Process '" + processId + "' not found.";
        }
        if (processInfo.getStatus() != ProcessStatus.RUNNING) {
            return "Error: Process '" + processId + "' is not running (status: " + processInfo.getStatus() + "). Cannot write input to terminated process.";
        }
        WriteProcessInputResponse result = processStateManager.writeProcessInput(processId, inputData, appendNewline);
        if (result.getSuccess()) {
            String inputPreview = inputData.length() > 50 ? StringsKt.take((String)inputData, (int)50) + "..." : inputData;
            string = "Successfully wrote input to process '" + processId + "': \"" + inputPreview + "\"";
        } else {
            string = "Failed to write input to process '" + processId + "': " + result.getErrorMessage();
        }
        return string;
    }

    private final Pair<String, Boolean> parseParameters(String prop) {
        boolean bl;
        String processId;
        block4: {
            String[] stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)prop)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string = (String)CollectionsKt.firstOrNull((List)parts);
            if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                string = "";
            }
            processId = string;
            Iterable $this$any$iv = parts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"--no-newline")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean appendNewline = !bl;
        return new Pair((Object)processId, (Object)appendNewline);
    }

    /*
     * WARNING - void declaration
     */
    private final String extractInputFromProp(String prop) {
        String[] stringArray = new String[]{" "};
        List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)prop)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() > 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CollectionsKt.drop((Iterable)parts, (int)1);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((String)it, (String)"--", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List inputParts = (List)destination$iv$iv;
            return CollectionsKt.joinToString$default((Iterable)inputParts, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
        return "";
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }
}

