/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.process;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.process.ProcessInfo;
import cc.unitmesh.devti.process.ProcessStateManager;
import cc.unitmesh.devti.process.ReadProcessOutputResponse;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J8\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/process/ReadProcessOutputInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseParameters", "Lcc/unitmesh/devti/language/compiler/exec/process/ReadProcessOutputInsCommand$Tuple4;", "", "", "formatOutput", "processId", "processInfo", "Lcc/unitmesh/devti/process/ProcessInfo;", "outputResponse", "Lcc/unitmesh/devti/process/ReadProcessOutputResponse;", "includeStdout", "includeStderr", "maxBytes", "Tuple4", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nReadProcessOutputInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadProcessOutputInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/ReadProcessOutputInsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1855#2,2:126\n1#3:128\n*S KotlinDebug\n*F\n+ 1 ReadProcessOutputInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/ReadProcessOutputInsCommand\n*L\n56#1:126,2\n*E\n"})
public final class ReadProcessOutputInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @NotNull
    private final BuiltinCommand commandName;

    public ReadProcessOutputInsCommand(@NotNull Project project, @NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        this.project = project;
        this.prop = prop;
        this.commandName = BuiltinCommand.READ_PROCESS_OUTPUT;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        ProcessStateManager processStateManager = ProcessStateManager.Companion.getInstance(this.project);
        Tuple4<String, Boolean, Boolean, Integer> tuple4 = this.parseParameters(this.prop);
        String processId = tuple4.component1();
        boolean includeStdout = tuple4.component2();
        boolean includeStderr = tuple4.component3();
        int maxBytes = ((Number)tuple4.component4()).intValue();
        if (((CharSequence)processId).length() == 0) {
            return "Error: Process ID is required. Usage: /read-process-output:process_id [--stdout] [--stderr] [--max-bytes=N]";
        }
        ProcessInfo processInfo = processStateManager.getProcess(processId);
        if (processInfo == null) {
            return "Error: Process '" + processId + "' not found.";
        }
        ReadProcessOutputResponse outputResponse = processStateManager.readProcessOutput(processId, includeStdout, includeStderr, maxBytes);
        return this.formatOutput(processId, processInfo, outputResponse, includeStdout, includeStderr, maxBytes);
    }

    private final Tuple4<String, Boolean, Boolean, Integer> parseParameters(String prop) {
        String[] stringArray = new String[]{" "};
        List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)prop)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = (String)CollectionsKt.firstOrNull((List)parts);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            string = "";
        }
        String processId = string;
        boolean includeStdout = false;
        includeStdout = true;
        boolean includeStderr = false;
        includeStderr = true;
        int maxBytes = 0;
        maxBytes = 10000;
        Iterable $this$forEach$iv = parts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String part = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)part, (Object)"--stdout-only")) {
                includeStdout = true;
                includeStderr = false;
                continue;
            }
            if (Intrinsics.areEqual((Object)part, (Object)"--stderr-only")) {
                includeStdout = false;
                includeStderr = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)part, (Object)"--no-stdout")) {
                includeStdout = false;
                continue;
            }
            if (Intrinsics.areEqual((Object)part, (Object)"--no-stderr")) {
                includeStderr = false;
                continue;
            }
            if (!StringsKt.startsWith$default((String)part, (String)"--max-bytes=", (boolean)false, (int)2, null)) continue;
            Integer n = StringsKt.toIntOrNull((String)StringsKt.substringAfter$default((String)part, (String)"=", null, (int)2, null));
            maxBytes = n != null ? n : 10000;
        }
        return new Tuple4<String, Boolean, Boolean, Integer>(processId, includeStdout, includeStderr, maxBytes);
    }

    private final String formatOutput(String processId, ProcessInfo processInfo, ReadProcessOutputResponse outputResponse, boolean includeStdout, boolean includeStderr, int maxBytes) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatOutput_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$formatOutput_u24lambda_u242.append("Process Output for: " + processId);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$formatOutput_u24lambda_u242.append("Command: " + processInfo.getCommand());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$formatOutput_u24lambda_u242.append("Status: " + processInfo.getStatus());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        Integer n = processInfo.getExitCode();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            StringBuilder stringBuilder5 = $this$formatOutput_u24lambda_u242.append("Exit Code: " + it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            v6 = stringBuilder6;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        } else {
            v6 = null;
        }
        StringBuilder stringBuilder7 = $this$formatOutput_u24lambda_u242.append(StringsKt.repeat((CharSequence)"=", (int)60));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$formatOutput_u24lambda_u242.append('\n'), (String)"append(...)");
        if (includeStdout && ((CharSequence)outputResponse.getStdout()).length() > 0) {
            StringBuilder stringBuilder8 = $this$formatOutput_u24lambda_u242.append("STDOUT:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder9 = $this$formatOutput_u24lambda_u242.append(StringsKt.repeat((CharSequence)"-", (int)40));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder10 = $this$formatOutput_u24lambda_u242.append(outputResponse.getStdout());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatOutput_u24lambda_u242.append('\n'), (String)"append(...)");
        }
        if (includeStderr && ((CharSequence)outputResponse.getStderr()).length() > 0) {
            StringBuilder stringBuilder11 = $this$formatOutput_u24lambda_u242.append("STDERR:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder12 = $this$formatOutput_u24lambda_u242.append(StringsKt.repeat((CharSequence)"-", (int)40));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder13 = $this$formatOutput_u24lambda_u242.append(outputResponse.getStderr());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatOutput_u24lambda_u242.append('\n'), (String)"append(...)");
        }
        if (((CharSequence)outputResponse.getStdout()).length() == 0 && ((CharSequence)outputResponse.getStderr()).length() == 0) {
            StringBuilder stringBuilder14 = $this$formatOutput_u24lambda_u242.append("No output available for this process.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatOutput_u24lambda_u242.append('\n'), (String)"append(...)");
        }
        if (outputResponse.getHasMore()) {
            StringBuilder stringBuilder15 = $this$formatOutput_u24lambda_u242.append("Note: Output was truncated to " + maxBytes + " bytes. Use --max-bytes=N to increase limit.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u00020\u0005B'\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u0012\u0006\u0010\b\u001a\u00028\u0002\u0012\u0006\u0010\t\u001a\u00028\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0013\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0014\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0015\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJN\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\u0007\u001a\u00028\u00012\b\b\u0002\u0010\b\u001a\u00028\u00022\b\b\u0002\u0010\t\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\b\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\t\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/process/ReadProcessOutputInsCommand$Tuple4;", "A", "B", "C", "D", "", "first", "second", "third", "fourth", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getFirst", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSecond", "getThird", "getFourth", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lcc/unitmesh/devti/language/compiler/exec/process/ReadProcessOutputInsCommand$Tuple4;", "equals", "", "other", "hashCode", "", "toString", "", "devins-lang"})
    private static final class Tuple4<A, B, C, D> {
        private final A first;
        private final B second;
        private final C third;
        private final D fourth;

        public Tuple4(A first, B second, C third, D fourth) {
            this.first = first;
            this.second = second;
            this.third = third;
            this.fourth = fourth;
        }

        public final A getFirst() {
            return this.first;
        }

        public final B getSecond() {
            return this.second;
        }

        public final C getThird() {
            return this.third;
        }

        public final D getFourth() {
            return this.fourth;
        }

        public final A component1() {
            return this.first;
        }

        public final B component2() {
            return this.second;
        }

        public final C component3() {
            return this.third;
        }

        public final D component4() {
            return this.fourth;
        }

        @NotNull
        public final Tuple4<A, B, C, D> copy(A first, B second, C third, D fourth) {
            return new Tuple4<A, B, C, D>(first, second, third, fourth);
        }

        public static /* synthetic */ Tuple4 copy$default(Tuple4 tuple4, Object object, Object object2, Object object3, Object object4, int n, Object object5) {
            if ((n & 1) != 0) {
                object = tuple4.first;
            }
            if ((n & 2) != 0) {
                object2 = tuple4.second;
            }
            if ((n & 4) != 0) {
                object3 = tuple4.third;
            }
            if ((n & 8) != 0) {
                object4 = tuple4.fourth;
            }
            return tuple4.copy(object, object2, object3, object4);
        }

        @NotNull
        public String toString() {
            return "Tuple4(first=" + this.first + ", second=" + this.second + ", third=" + this.third + ", fourth=" + this.fourth + ")";
        }

        public int hashCode() {
            int result = this.first == null ? 0 : this.first.hashCode();
            result = result * 31 + (this.second == null ? 0 : this.second.hashCode());
            result = result * 31 + (this.third == null ? 0 : this.third.hashCode());
            result = result * 31 + (this.fourth == null ? 0 : this.fourth.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tuple4)) {
                return false;
            }
            Tuple4 tuple4 = (Tuple4)other;
            if (!Intrinsics.areEqual(this.first, tuple4.first)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.second, tuple4.second)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.third, tuple4.third)) {
                return false;
            }
            return Intrinsics.areEqual(this.fourth, tuple4.fourth);
        }
    }
}

