/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.process;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.process.ProcessInfo;
import cc.unitmesh.devti.process.ProcessStateManager;
import cc.unitmesh.devti.process.ProcessStatus;
import com.intellij.openapi.project.Project;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/process/ListProcessesInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractMaxResults", "", "formatProcessList", "processes", "", "Lcc/unitmesh/devti/process/ProcessInfo;", "formatStatus", "status", "Lcc/unitmesh/devti/process/ProcessStatus;", "formatDuration", "durationMs", "", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nListProcessesInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListProcessesInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/ListProcessesInsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,129:1\n1054#2:130\n1855#2:131\n1856#2:134\n1774#2,4:135\n1774#2,4:139\n1774#2,4:143\n1774#2,4:147\n1774#2,4:151\n215#3,2:132\n*S KotlinDebug\n*F\n+ 1 ListProcessesInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/ListProcessesInsCommand\n*L\n30#1:130\n54#1:131\n54#1:134\n92#1:135,4\n93#1:139,4\n94#1:143,4\n95#1:147,4\n96#1:151,4\n74#1:132,2\n*E\n"})
public final class ListProcessesInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @NotNull
    private final BuiltinCommand commandName;

    public ListProcessesInsCommand(@NotNull Project project, @NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        this.project = project;
        this.prop = prop;
        this.commandName = BuiltinCommand.LIST_PROCESSES;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        void $this$sortedByDescending$iv;
        ProcessStateManager processStateManager = ProcessStateManager.Companion.getInstance(this.project);
        boolean includeTerminated = StringsKt.contains$default((CharSequence)this.prop, (CharSequence)"--include-terminated", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.prop, (CharSequence)"--all", (boolean)false, (int)2, null);
        int maxResults = this.extractMaxResults(this.prop);
        Iterable iterable = processStateManager.getAllProcesses(includeTerminated);
        boolean $i$f$sortedByDescending = false;
        List processes = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProcessInfo it = (ProcessInfo)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStartTime());
                it = (ProcessInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTime()));
            }
        }), (int)maxResults);
        if (processes.isEmpty()) {
            return "No processes found.";
        }
        return this.formatProcessList(processes);
    }

    private final int extractMaxResults(String prop) {
        Regex maxResultsRegex = new Regex("--max-results=(\\d+)");
        MatchResult match = Regex.find$default((Regex)maxResultsRegex, (CharSequence)prop, (int)0, (int)2, null);
        Object object = match;
        return object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 50;
    }

    private final String formatProcessList(List<ProcessInfo> processes) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuilder stringBuilder;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        StringBuilder $this$formatProcessList_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$formatProcessList_u24lambda_u2410.append("Process List (" + processes.size() + " processes):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$formatProcessList_u24lambda_u2410.append(StringsKt.repeat((CharSequence)"=", (int)80));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$formatProcessList_u24lambda_u2410.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = processes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessInfo process2 = (ProcessInfo)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder4 = $this$formatProcessList_u24lambda_u2410.append("Process ID: " + process2.getProcessId());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder5 = $this$formatProcessList_u24lambda_u2410.append("Command: " + process2.getCommand());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder6 = $this$formatProcessList_u24lambda_u2410.append("Working Directory: " + process2.getWorkingDirectory());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder7 = $this$formatProcessList_u24lambda_u2410.append("Status: " + this.formatStatus(process2.getStatus()));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            Integer n6 = process2.getExitCode();
            if (n6 != null) {
                int exitCode2 = ((Number)n6).intValue();
                boolean bl3 = false;
                StringBuilder stringBuilder8 = $this$formatProcessList_u24lambda_u2410.append("Exit Code: " + exitCode2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                StringBuilder stringBuilder9 = stringBuilder8.append('\n');
                v9 = stringBuilder9;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            } else {
                v9 = null;
            }
            StringBuilder stringBuilder10 = $this$formatProcessList_u24lambda_u2410.append("Start Time: " + dateFormat.format(new Date(process2.getStartTime())));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
            Long l = process2.getEndTime();
            if (l != null) {
                long endTime = ((Number)l).longValue();
                boolean bl4 = false;
                StringBuilder stringBuilder11 = $this$formatProcessList_u24lambda_u2410.append("End Time: " + dateFormat.format(new Date(endTime)));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
                long duration = endTime - process2.getStartTime();
                StringBuilder stringBuilder12 = $this$formatProcessList_u24lambda_u2410.append("Duration: " + this.formatDuration(duration));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
                StringBuilder stringBuilder13 = stringBuilder12.append('\n');
                v15 = stringBuilder13;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
            } else {
                v15 = null;
            }
            if (!process2.getEnvironment().isEmpty()) {
                StringBuilder stringBuilder14 = $this$formatProcessList_u24lambda_u2410.append("Environment Variables:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
                Map<String, String> $this$forEach$iv2 = process2.getEnvironment();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<String, String>> exitCode2 = $this$forEach$iv2.entrySet().iterator();
                while (exitCode2.hasNext()) {
                    Map.Entry<String, String> element$iv2;
                    Map.Entry<String, String> bl4 = element$iv2 = exitCode2.next();
                    boolean bl5 = false;
                    String key = bl4.getKey();
                    String value = bl4.getValue();
                    StringBuilder stringBuilder15 = $this$formatProcessList_u24lambda_u2410.append("  " + key + "=" + value);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
                }
            }
            if (process2.getWaitForCompletion()) {
                StringBuilder stringBuilder16 = $this$formatProcessList_u24lambda_u2410.append("Wait for Completion: Yes (Timeout: " + process2.getTimeoutSeconds() + "s)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16.append('\n'), (String)"append(...)");
            }
            if (process2.getShowInTerminal()) {
                StringBuilder stringBuilder17 = $this$formatProcessList_u24lambda_u2410.append("Show in Terminal: Yes");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append(...)");
            }
            StringBuilder stringBuilder18 = $this$formatProcessList_u24lambda_u2410.append(StringsKt.repeat((CharSequence)"-", (int)40));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatProcessList_u24lambda_u2410.append('\n'), (String)"append(...)");
        }
        Iterable $this$count$iv = processes;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n5 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ProcessInfo it = (ProcessInfo)element$iv;
                boolean bl6 = false;
                if (!(it.getStatus() == ProcessStatus.RUNNING) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n5 = count$iv;
        }
        int runningCount = n5;
        Iterable $this$count$iv2 = processes;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n4 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                ProcessInfo it = (ProcessInfo)element$iv;
                boolean bl7 = false;
                if (!(it.getStatus() == ProcessStatus.COMPLETED) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n4 = count$iv;
        }
        int completedCount = n4;
        Iterable $this$count$iv3 = processes;
        boolean $i$f$count3 = false;
        if ($this$count$iv3 instanceof Collection && ((Collection)$this$count$iv3).isEmpty()) {
            n3 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv3) {
                ProcessInfo it = (ProcessInfo)element$iv;
                boolean bl8 = false;
                if (!(it.getStatus() == ProcessStatus.FAILED) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int failedCount = n3;
        Iterable $this$count$iv4 = processes;
        boolean $i$f$count4 = false;
        if ($this$count$iv4 instanceof Collection && ((Collection)$this$count$iv4).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv4) {
                ProcessInfo it = (ProcessInfo)element$iv;
                boolean bl9 = false;
                if (!(it.getStatus() == ProcessStatus.KILLED) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int killedCount = n2;
        Iterable $this$count$iv5 = processes;
        boolean $i$f$count5 = false;
        if ($this$count$iv5 instanceof Collection && ((Collection)$this$count$iv5).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv5) {
                ProcessInfo it = (ProcessInfo)element$iv;
                boolean bl10 = false;
                if (!(it.getStatus() == ProcessStatus.TIMED_OUT) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int timedOutCount = n;
        StringBuilder stringBuilder19 = $this$formatProcessList_u24lambda_u2410.append("Summary:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder20 = $this$formatProcessList_u24lambda_u2410.append("  Running: " + runningCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder21 = $this$formatProcessList_u24lambda_u2410.append("  Completed: " + completedCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder22 = $this$formatProcessList_u24lambda_u2410.append("  Failed: " + failedCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder23 = $this$formatProcessList_u24lambda_u2410.append("  Killed: " + killedCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder24 = $this$formatProcessList_u24lambda_u2410.append("  Timed Out: " + timedOutCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String formatStatus(ProcessStatus status) {
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> "\ud83d\udfe2 RUNNING";
            case 2 -> "\u2705 COMPLETED";
            case 3 -> "\u274c FAILED";
            case 4 -> "\ud83d\uded1 KILLED";
            case 5 -> "\u23f0 TIMED_OUT";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String formatDuration(long durationMs) {
        long seconds = durationMs / (long)1000;
        long minutes = seconds / (long)60;
        long hours = minutes / (long)60;
        return hours > 0L ? hours + "h " + minutes % (long)60 + "m " + seconds % (long)60 + "s" : (minutes > 0L ? minutes + "m " + seconds % (long)60 + "s" : seconds + "s");
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProcessStatus.values().length];
            try {
                nArray[ProcessStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessStatus.COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessStatus.KILLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessStatus.TIMED_OUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

