/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.process;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.process.KillProcessResponse;
import cc.unitmesh.devti.process.ProcessInfo;
import cc.unitmesh.devti.process.ProcessStateManager;
import cc.unitmesh.devti.process.ProcessStatus;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/process/KillProcessInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseParameters", "Lkotlin/Pair;", "", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nKillProcessInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KillProcessInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/KillProcessInsCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n11#2:61\n1747#3,3:62\n*S KotlinDebug\n*F\n+ 1 KillProcessInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/process/KillProcessInsCommand\n*L\n19#1:61\n56#1:62,3\n*E\n"})
public final class KillProcessInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @NotNull
    private final BuiltinCommand commandName;
    @NotNull
    private final Logger logger;

    public KillProcessInsCommand(@NotNull Project project, @NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        this.project = project;
        this.prop = prop;
        this.commandName = BuiltinCommand.KILL_PROCESS;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KillProcessInsCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        String string;
        ProcessStateManager processStateManager = ProcessStateManager.Companion.getInstance(this.project);
        Pair<String, Boolean> pair = this.parseParameters(this.prop);
        String processId = (String)pair.component1();
        boolean force = (Boolean)pair.component2();
        if (((CharSequence)processId).length() == 0) {
            return "Error: Process ID is required. Usage: /kill-process:process_id [--force]";
        }
        ProcessInfo processInfo = processStateManager.getProcess(processId);
        if (processInfo == null) {
            return "Error: Process '" + processId + "' not found.";
        }
        if (processInfo.getStatus() != ProcessStatus.RUNNING) {
            return "Process '" + processId + "' is already terminated (status: " + processInfo.getStatus() + ").";
        }
        KillProcessResponse result = processStateManager.killProcess(processId, force);
        if (result.getSuccess()) {
            String killMethod = force ? "forcefully killed" : "gracefully terminated";
            string = "Process '" + processId + "' has been " + killMethod + " successfully.";
        } else {
            string = "Failed to kill process '" + processId + "': " + result.getErrorMessage();
        }
        return string;
    }

    private final Pair<String, Boolean> parseParameters(String prop) {
        boolean bl;
        String processId;
        block4: {
            String[] stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)prop)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string = (String)CollectionsKt.firstOrNull((List)parts);
            if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                string = "";
            }
            processId = string;
            Iterable $this$any$iv = parts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)it)).toString(), (Object)"--force")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean force = bl;
        return new Pair((Object)processId, (Object)force);
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }
}

