/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.idea;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinRefactorCommand;
import cc.unitmesh.devti.language.psi.DevInFile;
import cc.unitmesh.devti.provider.RefactoringTool;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/idea/RefactorInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "argument", "", "textSegment", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "devins-lang"})
public final class RefactorInsCommand
implements InsCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String argument;
    @NotNull
    private final String textSegment;
    @NotNull
    private final BuiltinCommand commandName;

    public RefactorInsCommand(@NotNull Project myProject, @NotNull String argument, @NotNull String textSegment) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)textSegment, (String)"textSegment");
        this.myProject = myProject;
        this.argument = argument;
        this.textSegment = textSegment;
        this.commandName = BuiltinCommand.REFACTOR;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        Language language;
        Language currentEditFile = null;
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor != null) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile == null) {
                return "File not found";
            }
            VirtualFile currentFile = virtualFile;
            PsiFile currentPsiFile = (PsiFile)ActionsKt.runReadAction(() -> RefactorInsCommand.execute$lambda$0(this, currentFile));
            currentEditFile = currentPsiFile instanceof DevInFile ? null : currentPsiFile;
        }
        if (((language = currentEditFile) == null || (language = language.getLanguage()) == null) && (language = Language.findLanguageByID((String)"JAVA")) == null) {
            return "Language not found";
        }
        Language language2 = language;
        RefactoringTool refactoringTool = RefactoringTool.Companion.forLanguage(language2);
        if (refactoringTool == null) {
            return "Refactoring tool not found for Java";
        }
        RefactoringTool refactoringTool2 = refactoringTool;
        BuiltinRefactorCommand builtinRefactorCommand = BuiltinRefactorCommand.Companion.fromString(this.argument);
        if (builtinRefactorCommand == null) {
            return "Unknown refactor command: " + this.argument;
        }
        BuiltinRefactorCommand command = builtinRefactorCommand;
        switch (WhenMappings.$EnumSwitchMapping$0[command.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{" to "};
                List list = StringsKt.split$default((CharSequence)this.textSegment, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String from = (String)list.get(0);
                String to = (String)list.get(1);
                boolean bl = refactoringTool2.rename(((Object)StringsKt.trim((CharSequence)from)).toString(), ((Object)StringsKt.trim((CharSequence)to)).toString(), (PsiFile)currentEditFile);
                break;
            }
            case 2: {
                PsiFile psiFile2 = refactoringTool2.lookupFile(((Object)StringsKt.trim((CharSequence)this.textSegment)).toString());
                if (psiFile2 == null) {
                    return "File not found";
                }
                PsiFile psiFile3 = psiFile2;
                boolean bl = refactoringTool2.safeDelete((PsiElement)psiFile3);
                break;
            }
            case 3: {
                PsiFile psiFile4 = refactoringTool2.lookupFile(((Object)StringsKt.trim((CharSequence)this.textSegment)).toString());
                if (psiFile4 == null) {
                    return "File not found";
                }
                PsiFile psiFile5 = psiFile4;
                boolean bl = refactoringTool2.safeDelete((PsiElement)psiFile5);
                break;
            }
            case 4: {
                Object from = new String[]{" to "};
                List list = StringsKt.split$default((CharSequence)this.textSegment, (String[])from, (boolean)false, (int)0, (int)6, null);
                from = (String)list.get(0);
                String to = (String)list.get(1);
                PsiFile psiFile6 = refactoringTool2.lookupFile(((Object)StringsKt.trim((CharSequence)((CharSequence)from))).toString());
                if (psiFile6 == null) {
                    return "File not found";
                }
                PsiFile psiFile7 = psiFile6;
                boolean bl = refactoringTool2.move((PsiElement)psiFile7, ((Object)StringsKt.trim((CharSequence)to)).toString());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final PsiFile execute$lambda$0(RefactorInsCommand this$0, VirtualFile $currentFile) {
        return PsiManager.getInstance((Project)this$0.myProject).findFile($currentFile);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuiltinRefactorCommand.values().length];
            try {
                nArray[BuiltinRefactorCommand.RENAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltinRefactorCommand.SAFEDELETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltinRefactorCommand.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltinRefactorCommand.MOVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

