/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.file;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import cc.unitmesh.devti.language.compiler.exec.file.WriteInsCommandKt;
import cc.unitmesh.devti.language.psi.DevInUsed;
import cc.unitmesh.devti.language.utils.ProjectFileUtilKt;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/WriteInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "argument", "", "content", "used", "Lcc/unitmesh/devti/language/psi/DevInUsed;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Lcc/unitmesh/devti/language/psi/DevInUsed;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getArgument", "()Ljava/lang/String;", "getContent", "getUsed", "()Lcc/unitmesh/devti/language/psi/DevInUsed;", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeToFile", "filepath", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "runWriteAction", "action", "Lkotlin/Function0;", "createFileWithContent", "parentDir", "fileName", "Companion", "devins-lang"})
public final class WriteInsCommand
implements InsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String argument;
    @NotNull
    private final String content;
    @NotNull
    private final DevInUsed used;
    @NotNull
    private final BuiltinCommand commandName;
    @NotNull
    private static final String pathSeparator = "/";

    public WriteInsCommand(@NotNull Project myProject, @NotNull String argument, @NotNull String content, @NotNull DevInUsed used) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)used, (String)"used");
        this.myProject = myProject;
        this.argument = argument;
        this.content = content;
        this.used = used;
        this.commandName = BuiltinCommand.WRITE;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final DevInUsed getUsed() {
        return this.used;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        String[] stringArray = new String[]{"#"};
        String filepath = (String)StringsKt.split$default((CharSequence)this.argument, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (virtualFile == null) {
            return DevInErrorKt.getDEVINS_ERROR() + ": Project directory not found";
        }
        VirtualFile projectDir = virtualFile;
        boolean fileExists = (Boolean)ActionsKt.runReadAction(() -> WriteInsCommand.execute$lambda$0(this, filepath));
        if (!fileExists) {
            return this.writeToFile(filepath, projectDir);
        }
        Object object = ActionsKt.runReadAction(() -> WriteInsCommand.execute$lambda$1(this, filepath));
        Intrinsics.checkNotNull((Object)object);
        VirtualFile virtualFile2 = (VirtualFile)object;
        ActionsKt.runInEdt$default(null, () -> WriteInsCommand.execute$lambda$2(virtualFile2, this), (int)1, null);
        return "Writing to file: " + this.argument;
    }

    private final String writeToFile(String filepath, VirtualFile projectDir) {
        boolean hasChildPath = StringsKt.contains$default((CharSequence)filepath, (CharSequence)pathSeparator, (boolean)false, (int)2, null);
        if (!hasChildPath) {
            Object object = this.runWriteAction((Function0<String>)((Function0)() -> WriteInsCommand.writeToFile$lambda$3(this, projectDir, filepath)));
            if (object == null) {
                object = DevInErrorKt.getDEVINS_ERROR() + ": Create File failed: " + this.argument;
            }
            return object;
        }
        String filename = StringsKt.substringAfterLast$default((String)filepath, (String)pathSeparator, null, (int)2, null);
        String dirPath = StringsKt.substringBeforeLast$default((String)filepath, (String)pathSeparator, null, (int)2, null);
        String string = this.runWriteAction((Function0<String>)((Function0)() -> WriteInsCommand.writeToFile$lambda$4(projectDir, dirPath, this, filename)));
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String runWriteAction(Function0<String> action) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        CheckedDisposable disposable = checkedDisposable;
        WriteInsCommandKt.runInEdtAsync(disposable, (Function0<Unit>)((Function0)() -> WriteInsCommand.runWriteAction$lambda$6(result, this, action)));
        return (String)result.element;
    }

    private final String createFileWithContent(VirtualFile parentDir, String fileName) {
        if (((CharSequence)fileName).length() == 0) {
            return DevInErrorKt.getDEVINS_ERROR() + ": File name is empty: " + this.argument;
        }
        try {
            VirtualFile virtualFile = parentDir.createChildData((Object)this, fileName);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
            VirtualFile newFile = virtualFile;
            SingleFileDiffSketchKt.writeText(newFile, this.content);
            return "Writing to file: " + this.argument;
        }
        catch (Exception e) {
            return DevInErrorKt.getDEVINS_ERROR() + ": " + e.getMessage();
        }
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final boolean execute$lambda$0(WriteInsCommand this$0, String $filepath) {
        return ProjectFileUtilKt.lookupFile(this$0.myProject, $filepath) != null;
    }

    private static final VirtualFile execute$lambda$1(WriteInsCommand this$0, String $filepath) {
        return ProjectFileUtilKt.lookupFile(this$0.myProject, $filepath);
    }

    private static final Unit execute$lambda$2(VirtualFile $virtualFile, WriteInsCommand this$0) {
        SingleFileDiffSketchKt.writeText($virtualFile, this$0.content);
        if (!AutoSketchMode.Companion.getInstance(this$0.myProject).isEnable()) {
            FileEditorManager.getInstance((Project)this$0.myProject).openFile($virtualFile, true);
        }
        return Unit.INSTANCE;
    }

    private static final String writeToFile$lambda$3(WriteInsCommand this$0, VirtualFile $projectDir, String $filepath) {
        return this$0.createFileWithContent($projectDir, $filepath);
    }

    private static final String writeToFile$lambda$4(VirtualFile $projectDir, String $dirPath, WriteInsCommand this$0, String $filename) {
        VirtualFile currentDir = Companion.getOrCreateDirectory($projectDir, $dirPath);
        return this$0.createFileWithContent(currentDir, $filename);
    }

    private static final String runWriteAction$lambda$6$lambda$5(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final Unit runWriteAction$lambda$6(Ref.ObjectRef $result, WriteInsCommand this$0, Function0 $action) {
        $result.element = WriteCommandAction.runWriteCommandAction((Project)this$0.myProject, () -> WriteInsCommand.runWriteAction$lambda$6$lambda$5($action));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/WriteInsCommand$Companion;", "", "<init>", "()V", "pathSeparator", "", "getOrCreateDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "baseDir", "path", "devins-lang"})
    @SourceDebugExtension(value={"SMAP\nWriteInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/file/WriteInsCommand$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n766#2:109\n857#2,2:110\n*S KotlinDebug\n*F\n+ 1 WriteInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/file/WriteInsCommand$Companion\n*L\n92#1:109\n92#1:110,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VirtualFile getOrCreateDirectory(@NotNull VirtualFile baseDir, @NotNull String path) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            VirtualFile currentDir = baseDir;
            String[] stringArray = new String[]{pathSeparator};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List pathSegments = (List)destination$iv$iv;
            for (String segment : pathSegments) {
                VirtualFile childDir = currentDir.findChild(segment);
                VirtualFile virtualFile = childDir;
                if (virtualFile == null) {
                    VirtualFile virtualFile2 = currentDir.createChildDirectory((Object)this, segment);
                    virtualFile = virtualFile2;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildDirectory(...)");
                }
                currentDir = virtualFile;
            }
            return currentDir;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

