/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.file;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.InsCommandListener;
import cc.unitmesh.devti.command.InsCommandStatus;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.model.LineInfo;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001a\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/FileInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "prop", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "MAX_LINES", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchInDependencies", "Lcom/intellij/openapi/vfs/VirtualFile;", "filepath", "splitLines", "range", "Lcc/unitmesh/devti/language/compiler/model/LineInfo;", "content", "limitMaxSize", "size", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nFileInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/file/FileInsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,197:1\n288#2,2:198\n1282#3,2:200\n1282#3,2:202\n*S KotlinDebug\n*F\n+ 1 FileInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/file/FileInsCommand\n*L\n113#1:198,2\n136#1:200,2\n154#1:202,2\n*E\n"})
public final class FileInsCommand
implements InsCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String prop;
    @NotNull
    private final BuiltinCommand commandName;
    private final int MAX_LINES;

    public FileInsCommand(@NotNull Project myProject, @NotNull String prop) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        this.myProject = myProject;
        this.prop = prop;
        this.commandName = BuiltinCommand.FILE;
        this.MAX_LINES = 300;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        LineInfo range = LineInfo.Companion.fromString(this.prop);
        String[] stringArray = new String[]{"#"};
        String filepath = (String)StringsKt.split$default((CharSequence)this.prop, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        Ref.ObjectRef virtualFile = new Ref.ObjectRef();
        virtualFile.element = cc.unitmesh.devti.language.utils.ProjectFileUtilKt.lookupFile(this.myProject, filepath);
        if (virtualFile.element == null) {
            String[] stringArray2 = new String[]{"/"};
            String filename = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)filepath, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            try {
                virtualFile.element = ActionsKt.runReadAction(() -> FileInsCommand.execute$lambda$0(this, filename));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (virtualFile.element == null) {
            virtualFile.element = this.searchInDependencies(filepath);
        }
        if (virtualFile.element == null) {
            AutoDevNotifications.INSTANCE.warn(this.myProject, "File not found: " + this.prop);
            return "File not found: " + this.prop;
        }
        InsCommandListener.Companion.notify(this, InsCommandStatus.SUCCESS, (VirtualFile)virtualFile.element);
        Pair pair = (Pair)ActionsKt.runReadAction(() -> FileInsCommand.execute$lambda$2(this, virtualFile));
        String content = (String)pair.component1();
        String lang = (String)pair.component2();
        if (content == null) {
            AutoDevNotifications.INSTANCE.warn(this.myProject, "Cannot read file: " + this.prop);
            return "Cannot read file: " + this.prop;
        }
        String fileContent = this.splitLines(range, content);
        String realPath = ProjectFileUtilKt.relativePath((VirtualFile)virtualFile.element, this.myProject);
        StringBuilder output = new StringBuilder();
        output.append("## file: " + realPath);
        output.append("\n```" + lang + "\n");
        output.append(fileContent);
        output.append("\n```\n");
        return output.toString();
    }

    private final VirtualFile searchInDependencies(String filepath) {
        return (VirtualFile)ActionsKt.runReadAction(() -> FileInsCommand.searchInDependencies$lambda$6(filepath, this));
    }

    private final String splitLines(LineInfo range, String content) {
        String string;
        List lines = StringsKt.lines((CharSequence)content);
        int currentSize = lines.size();
        if (range == null) {
            string = this.limitMaxSize(currentSize, content);
        } else {
            int endLine = Math.min(range.getEndLine(), currentSize);
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice((List)lines, (IntRange)RangesKt.until((int)(range.getStartLine() - 1), (int)endLine)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    private final String limitMaxSize(int size, String content) {
        Object object;
        if (size > this.MAX_LINES) {
            String[] stringArray = new String[]{"\n"};
            String code = CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice((List)StringsKt.split$default((CharSequence)content, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (IntRange)RangesKt.until((int)0, (int)this.MAX_LINES)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            int nextChunkStart = this.MAX_LINES + 1;
            int nextChunkEnd = Math.min(size, this.MAX_LINES * 2);
            String suggestion = nextChunkEnd > nextChunkStart ? "\nUse `filename#L" + nextChunkStart + "-L" + nextChunkEnd + "` to get next chunk of lines." : "";
            object = "File too long, only showing first " + this.MAX_LINES + " lines of " + size + " total lines.\n" + code + suggestion;
        } else {
            object = content;
        }
        return object;
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final VirtualFile execute$lambda$0(FileInsCommand this$0, String $filename) {
        return cc.unitmesh.devti.language.utils.ProjectFileUtilKt.findFile(this$0.myProject, $filename, false);
    }

    private static final String execute$lambda$2$lambda$1(Ref.ObjectRef $virtualFile) {
        return SingleFileDiffSketchKt.readText((VirtualFile)$virtualFile.element);
    }

    private static final Pair execute$lambda$2(FileInsCommand this$0, Ref.ObjectRef $virtualFile) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)this$0.myProject).findFile((VirtualFile)$virtualFile.element);
        Object object = psiFile2;
        if (object == null || (object = object.getLanguage()) == null || (object = object.getDisplayName()) == null) {
            object = "";
        }
        Object language = object;
        String fileContent = psiFile2 instanceof ClsFileImpl ? ((ClsFileImpl)psiFile2).getText() : (String)ActionsKt.runReadAction(() -> FileInsCommand.execute$lambda$2$lambda$1($virtualFile));
        return new Pair((Object)fileContent, language);
    }

    /*
     * Unable to fully structure code
     */
    private static final VirtualFile searchInDependencies$lambda$6(String $filepath, FileInsCommand this$0) {
        block15: {
            block12: {
                var3_2 = new String[]{"/"};
                filename = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)$filepath, (String[])var3_2, (boolean)false, (int)0, (int)6, null));
                if (!StringsKt.contains$default((CharSequence)filename, (CharSequence)".", (boolean)false, (int)2, null)) break block15;
                v0 = FilenameIndex.getVirtualFilesByName((String)filename, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this$0.myProject));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getVirtualFilesByName(...)");
                files = v0;
                $this$firstOrNull$iv = files;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    virtualFile = (VirtualFile)element$iv;
                    $i$a$-firstOrNull-FileInsCommand$searchInDependencies$1$matchedFile$1 = false;
                    v1 = virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                    if (StringsKt.endsWith$default((String)v1, (String)$filepath, (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    v2 = virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                    if (StringsKt.contains$default((CharSequence)v2, (CharSequence)$filepath, (boolean)false, (int)2, null)) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    if (!v3) continue;
                    v4 = element$iv;
                    break block12;
                }
                v4 = null;
            }
            matchedFile = v4;
            if (matchedFile != null) {
                return matchedFile;
            }
            if (files.isEmpty() == false) {
                return (VirtualFile)CollectionsKt.first((Iterable)files);
            }
        }
        className = StringsKt.contains$default((CharSequence)filename, (CharSequence)".", (boolean)false, (int)2, null) != false ? StringsKt.substringBeforeLast$default((String)filename, (String)".", null, (int)2, null) : filename;
        v5 = PsiShortNamesCache.getInstance((Project)this$0.myProject).getClassesByName(className, GlobalSearchScope.allScope((Project)this$0.myProject));
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getClassesByName(...)");
        psiClasses = v5;
        if (psiClasses.length == 0 == false) {
            block13: {
                $this$firstOrNull$iv = psiClasses;
                $i$f$firstOrNull = false;
                virtualFile = $this$firstOrNull$iv.length;
                for (element$iv = 0; element$iv < virtualFile; ++element$iv) {
                    psiClass = element$iv = $this$firstOrNull$iv[element$iv];
                    $i$a$-firstOrNull-FileInsCommand$searchInDependencies$1$matchedClass$1 = false;
                    v6 = psiClass.getQualifiedName();
                    if (v6 == null) {
                        v6 = "";
                    }
                    if (!StringsKt.contains$default((CharSequence)StringsKt.replace$default((String)(qualifiedName = v6), (String)".", (String)"/", (boolean)false, (int)4, null), (CharSequence)StringsKt.replace$default((String)$filepath, (String)".", (String)"/", (boolean)false, (int)4, null), (boolean)false, (int)2, null)) continue;
                    v7 = element$iv;
                    break block13;
                }
                v7 = null;
            }
            if ((v8 = (matchedClass = v7)) == null) {
                v8 = (PsiClass)ArraysKt.first((Object[])psiClasses);
            }
            v9 = v8.getContainingFile();
            return v9 != null ? v9.getVirtualFile() : null;
        }
        if (StringsKt.contains$default((CharSequence)$filepath, (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)filename, (CharSequence)"/", (boolean)false, (int)2, null)) {
            block14: {
                v10 = GlobalSearchScope.allScope((Project)this$0.myProject);
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"allScope(...)");
                scope = v10;
                fullyQualifiedName = StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)$filepath, (String)".java", null, (int)2, null), (String)".kt", null, (int)2, null), (String)"/", (String)".", (boolean)false, (int)4, null);
                v11 = PsiShortNamesCache.getInstance((Project)this$0.myProject).getClassesByName(StringsKt.substringAfterLast$default((String)fullyQualifiedName, (String)".", null, (int)2, null), scope);
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getClassesByName(...)");
                $this$firstOrNull$iv = classes = v11;
                $i$f$firstOrNull = false;
                var12_20 = $this$firstOrNull$iv.length;
                for (var11_18 = 0; var11_18 < var12_20; ++var11_18) {
                    it = element$iv = $this$firstOrNull$iv[var11_18];
                    $i$a$-firstOrNull-FileInsCommand$searchInDependencies$1$matchedClass$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)fullyQualifiedName)) continue;
                    v12 = element$iv;
                    break block14;
                }
                v12 = matchedClass = null;
            }
            if (matchedClass != null) {
                v13 = matchedClass.getContainingFile();
                return v13 != null ? v13.getVirtualFile() : null;
            }
        }
        return null;
    }
}

