/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.file;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.command.EditFileCommand;
import cc.unitmesh.devti.command.EditRequest;
import cc.unitmesh.devti.command.EditResult;
import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/EditFileInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "prop", "", "codeContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getProp", "()Ljava/lang/String;", "getCodeContent", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldShowParseErrorNotification", "", "Companion", "devins-lang"})
public final class EditFileInsCommand
implements InsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String prop;
    @NotNull
    private final String codeContent;
    @NotNull
    private final BuiltinCommand commandName;
    private static final int MAX_ERRORS_IN_WINDOW = 3;
    private static final long ERROR_TIME_WINDOW_MS = 60000L;
    private static int parseErrorCount;
    private static long lastErrorTime;

    public EditFileInsCommand(@NotNull Project myProject, @NotNull String prop, @NotNull String codeContent) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)codeContent, (String)"codeContent");
        this.myProject = myProject;
        this.prop = prop;
        this.codeContent = codeContent;
        this.commandName = BuiltinCommand.EDIT_FILE;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final String getProp() {
        return this.prop;
    }

    @NotNull
    public final String getCodeContent() {
        return this.codeContent;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        Object object;
        EditFileCommand editFileCommand = new EditFileCommand(this.myProject);
        EditRequest editRequest = editFileCommand.parseEditRequest(this.codeContent);
        if (editRequest == null) {
            boolean shouldShowNotification = this.shouldShowParseErrorNotification();
            if (shouldShowNotification) {
                AutoDevNotifications.INSTANCE.warn(this.myProject, "Failed to parse edit_file request from content");
            }
            return DevInErrorKt.getDEVINS_ERROR() + ": Failed to parse edit_file request";
        }
        EditResult result = editFileCommand.executeEdit(editRequest);
        EditResult editResult = result;
        if (editResult instanceof EditResult.Success) {
            ActionsKt.runInEdt$default(null, () -> EditFileInsCommand.execute$lambda$0(this, result), (int)1, null);
            object = AutoSketchMode.Companion.getInstance(this.myProject).isEnable() ? "" : ((EditResult.Success)result).getMessage();
        } else if (editResult instanceof EditResult.Error) {
            object = DevInErrorKt.getDEVINS_ERROR() + ": " + ((EditResult.Error)result).getMessage();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final boolean shouldShowParseErrorNotification() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastErrorTime > 60000L) {
            parseErrorCount = 0;
            lastErrorTime = currentTime;
        }
        int n = parseErrorCount;
        parseErrorCount = n + 1;
        return parseErrorCount <= 3;
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final Unit execute$lambda$0(EditFileInsCommand this$0, EditResult $result) {
        FileEditorManager.getInstance((Project)this$0.myProject).openFile(((EditResult.Success)$result).getTargetFile(), true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/EditFileInsCommand$Companion;", "", "<init>", "()V", "MAX_ERRORS_IN_WINDOW", "", "ERROR_TIME_WINDOW_MS", "", "parseErrorCount", "lastErrorTime", "devins-lang"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

