/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.file;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.exec.file.DirInsCommand;
import cc.unitmesh.devti.language.utils.ProjectFileUtilKt;
import cc.unitmesh.devti.vcs.gitignore.GitIgnoreUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0016J\"\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J<\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050%2\u0006\u0010'\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0019\u001a\u00020\u00032\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0%H\u0002J.\u0010+\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0%2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0%H\u0002J$\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0002J\u0018\u00101\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "dir", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "HASH_FILE_PATTERN", "Ljava/util/regex/Pattern;", "isHashJson", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listDirectory", "", "project", "directory", "Lcom/intellij/psi/PsiDirectory;", "depth", "", "isExclude", "defaultMaxDepth", "executeDepth", "buildDirectoryTree", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$DirectoryNode;", "processRemainingDirs", "allDirs", "", "parallelDirNames", "parentNode", "detectParallelSimpleDirs", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$ParallelDirsNode;", "subdirs", "shouldCompressSubdirectories", "subdirectories", "getCompressableSubdirectories", "renderTree", "node", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode;", "isExcluded", "TreeNode", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nDirInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/file/DirInsCommand\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n13309#2,2:369\n3792#2:371\n4307#2,2:372\n3792#2:386\n4307#2,2:387\n3792#2:404\n4307#2,2:405\n1549#3:374\n1620#3,3:375\n1855#3,2:378\n766#3:380\n857#3,2:381\n1855#3,2:383\n1855#3:385\n1856#3:396\n1549#3:398\n1620#3,3:399\n1726#3,2:402\n1726#3,3:407\n1728#3:410\n1864#3,3:411\n372#4,7:389\n1#5:397\n*S KotlinDebug\n*F\n+ 1 DirInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/file/DirInsCommand\n*L\n198#1:369,2\n205#1:371\n205#1:372,2\n266#1:386\n266#1:387,2\n297#1:404\n297#1:405,2\n223#1:374\n223#1:375,3\n227#1:378,2\n247#1:380\n247#1:381,2\n248#1:383,2\n265#1:385\n265#1:396\n279#1:398\n279#1:399,3\n296#1:402,2\n298#1:407,3\n296#1:410\n319#1:411,3\n269#1:389,7\n*E\n"})
public final class DirInsCommand
implements InsCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String dir;
    @NotNull
    private final BuiltinCommand commandName;
    @NotNull
    private final Pattern HASH_FILE_PATTERN;
    @NotNull
    private final StringBuilder output;
    private final int defaultMaxDepth;

    public DirInsCommand(@NotNull Project myProject, @NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.myProject = myProject;
        this.dir = dir;
        this.commandName = BuiltinCommand.DIR;
        Pattern pattern = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}(?:\\.json|@[0-9a-f]+\\.json)$", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.HASH_FILE_PATTERN = pattern;
        this.output = new StringBuilder();
        this.defaultMaxDepth = 2;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    public final boolean isHashJson(@Nullable VirtualFile file) {
        return file != null && this.HASH_FILE_PATTERN.matcher(file.getName()).matches();
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        VirtualFile virtualFile = ProjectFileUtilKt.lookupFile(this.myProject, this.dir);
        if (virtualFile == null) {
            return "File not found: " + this.dir;
        }
        VirtualFile virtualFile2 = virtualFile;
        CompletableFuture<String> future = new CompletableFuture<String>();
        Project project = this.myProject;
        Task.Backgroundable task2 = new Task.Backgroundable(future, this, virtualFile2, project){
            final /* synthetic */ CompletableFuture<String> $future;
            final /* synthetic */ DirInsCommand this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$future = $future;
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super($super_call_param$1, "Processing context", false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PsiDirectory psiDirectory = (PsiDirectory)ActionsKt.runReadAction(() -> execute.task.1.run$lambda$0(this, this.$virtualFile));
                if (psiDirectory == null) {
                    this.$future.complete("Directory not found: " + DirInsCommand.access$getDir$p(this.this$0));
                    return;
                }
                StringBuilder stringBuilder = DirInsCommand.access$getOutput$p(this.this$0).append(DirInsCommand.access$getDir$p(this.this$0) + "/");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                ActionsKt.runReadAction(() -> execute.task.1.run$lambda$1(this.this$0, this, psiDirectory));
                this.$future.complete(DirInsCommand.access$getOutput$p(this.this$0).toString());
            }

            private static final PsiDirectory run$lambda$0(execute.task.1 this$0, VirtualFile $virtualFile) {
                Project project = this$0.myProject;
                Intrinsics.checkNotNull((Object)project);
                return PsiManager.getInstance((Project)project).findDirectory($virtualFile);
            }

            private static final Unit run$lambda$1(DirInsCommand this$0, execute.task.1 this$1, PsiDirectory $psiDirectory) {
                Project project = this$1.myProject;
                Intrinsics.checkNotNull((Object)project);
                DirInsCommand.access$listDirectory(this$0, project, $psiDirectory, 1);
                return Unit.INSTANCE;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        return future.get();
    }

    private final void listDirectory(Project project, PsiDirectory directory, int depth) {
        int index;
        int n;
        if (this.isExclude(project, directory)) {
            return;
        }
        PsiFile[] psiFileArray = directory.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
        PsiFile[] files = psiFileArray;
        PsiDirectory[] psiDirectoryArray = directory.getSubdirectories();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
        PsiDirectory[] subdirectories = psiDirectoryArray;
        int n2 = files.length;
        for (n = 0; n < n2; ++n) {
            StringBuilder stringBuilder;
            index = n;
            PsiFile file = files[n];
            if (file.getFileType().isBinary() || this.isHashJson(file.getVirtualFile())) continue;
            if (index == files.length - 1) {
                StringBuilder stringBuilder2 = this.output.append(StringsKt.repeat((CharSequence)"  ", (int)depth) + "\u2514\u2500\u2500 " + file.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                stringBuilder = stringBuilder3;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                continue;
            }
            StringBuilder stringBuilder4 = this.output.append(StringsKt.repeat((CharSequence)"  ", (int)depth) + "\u251c\u2500\u2500 " + file.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            StringBuilder stringBuilder5 = stringBuilder4.append('\n');
            stringBuilder = stringBuilder5;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        }
        n2 = subdirectories.length;
        for (n = 0; n < n2; ++n) {
            index = n;
            PsiDirectory subdirectory = subdirectories[n];
            if (this.isExclude(project, directory)) continue;
            if (index == subdirectories.length - 1) {
                StringBuilder stringBuilder = this.output.append(StringsKt.repeat((CharSequence)"  ", (int)depth) + "\u2514\u2500\u2500 " + subdirectory.getName() + "/");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                StringBuilder stringBuilder6 = stringBuilder.append('\n');
                v9 = stringBuilder6;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            } else {
                StringBuilder stringBuilder = this.output.append(StringsKt.repeat((CharSequence)"  ", (int)depth) + "\u251c\u2500\u2500 " + subdirectory.getName() + "/");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                StringBuilder stringBuilder7 = stringBuilder.append('\n');
                v9 = stringBuilder7;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            }
            Intrinsics.checkNotNull((Object)subdirectory);
            this.listDirectory(project, subdirectory, depth + 1);
        }
    }

    private final boolean isExclude(Project project, PsiDirectory directory) {
        boolean bl;
        if (Intrinsics.areEqual((Object)directory.getName(), (Object)".idea")) {
            return true;
        }
        try {
            VirtualFile virtualFile = directory.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            bl = GitIgnoreUtil.INSTANCE.isIgnored(project, virtualFile);
        }
        catch (Exception e) {
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(directory.getVirtualFile());
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            bl = Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
        }
        return bl;
    }

    @Nullable
    public final Object executeDepth(@NotNull Continuation<? super String> $completion) {
        StringBuilder stringBuilder;
        VirtualFile virtualFile = ProjectFileUtilKt.lookupFile(this.myProject, this.dir);
        if (virtualFile == null) {
            return "File not found: " + this.dir;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile2);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        TreeNode.DirectoryNode directoryNode = (TreeNode.DirectoryNode)ActionsKt.runReadAction(() -> DirInsCommand.executeDepth$lambda$0(this, psiDirectory2));
        if (directoryNode == null) {
            return null;
        }
        TreeNode.DirectoryNode rootNode = directoryNode;
        StringBuilder $this$executeDepth_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$executeDepth_u24lambda_u241.append(this.dir + "/");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        this.renderTree(rootNode, 1, $this$executeDepth_u24lambda_u241);
        StringBuilder output = stringBuilder;
        return output.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final TreeNode.DirectoryNode buildDirectoryTree(Project project, PsiDirectory directory, int depth) {
        Iterable $this$filterTo$iv$iv;
        if (this.isExcluded(project, directory)) {
            return null;
        }
        String string = directory.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        TreeNode.DirectoryNode dirNode = new TreeNode.DirectoryNode(string, null, 2, null);
        if (depth <= this.defaultMaxDepth) {
            PsiFile[] psiFileArray = directory.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
            Object[] $this$forEach$iv = psiFileArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fileSize;
                PsiFile file = (PsiFile)element$iv;
                int n = 0;
                Intrinsics.checkNotNullExpressionValue((Object)StringUtilRt.formatFileSize((long)file.getVirtualFile().getLength()), (String)"formatFileSize(...)");
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                dirNode.addChild(new TreeNode.FileNode(string2, fileSize));
            }
        }
        PsiDirectory[] psiDirectoryArray = directory.getSubdirectories();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
        Object[] $this$filter$iv = psiDirectoryArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Iterator element$iv$iv : $this$filterTo$iv$iv) {
            PsiDirectory it = (PsiDirectory)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!this.isExcluded(project, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List subdirectories = (List)destination$iv$iv;
        TreeNode.ParallelDirsNode parallelDirsNode = this.detectParallelSimpleDirs(project, subdirectories);
        if (parallelDirsNode != null) {
            dirNode.addChild(parallelDirsNode);
            this.processRemainingDirs(project, subdirectories, parallelDirsNode.getDirNames(), dirNode, depth);
            return dirNode;
        }
        if (this.shouldCompressSubdirectories(project, directory, subdirectories, depth)) {
            List<PsiDirectory> compressableSubdirs = this.getCompressableSubdirectories(subdirectories);
            if (!((Collection)compressableSubdirs).isEmpty()) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filterTo$iv$iv = compressableSubdirs;
                String string3 = "compressed";
                TreeNode.DirectoryNode directoryNode = dirNode;
                boolean $i$f$map = false;
                void $i$f$filterTo2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsiDirectory bl = (PsiDirectory)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string4 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    collection.add(string4);
                }
                collection = (List)destination$iv$iv2;
                List list = collection;
                String string5 = string3;
                directoryNode.addChild(new TreeNode.CompressedNode(string5, list));
            }
        } else {
            Iterable $this$forEach$iv = subdirectories;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeNode.DirectoryNode subdirNode;
                PsiDirectory subdir = (PsiDirectory)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)subdir);
                if (this.buildDirectoryTree(project, subdir, depth + 1) == null) continue;
                boolean bl3 = false;
                dirNode.addChild(subdirNode);
            }
        }
        return dirNode;
    }

    /*
     * WARNING - void declaration
     */
    private final void processRemainingDirs(Project project, List<? extends PsiDirectory> allDirs, List<String> parallelDirNames, TreeNode.DirectoryNode parentNode, int depth) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = allDirs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiDirectory dir = (PsiDirectory)element$iv$iv;
            boolean bl = false;
            if (!(!parallelDirNames.contains(dir.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List remainingDirs = (List)destination$iv$iv;
        Iterable $this$forEach$iv = remainingDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeNode.DirectoryNode subdirNode;
            PsiDirectory dir = (PsiDirectory)element$iv;
            boolean bl = false;
            if (this.buildDirectoryTree(project, dir, depth + 1) == null) continue;
            boolean bl2 = false;
            parentNode.addChild(subdirNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TreeNode.ParallelDirsNode detectParallelSimpleDirs(Project project, List<? extends PsiDirectory> subdirs) {
        Object object;
        Object dir;
        Object element$iv2;
        if (subdirs.size() < 2) {
            return null;
        }
        Map dirGroups = new LinkedHashMap();
        Iterable $this$forEach$iv = subdirs;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Object object2;
            String childName;
            void $this$filterTo$iv$iv;
            dir = (PsiDirectory)element$iv2;
            boolean bl = false;
            PsiDirectory[] psiDirectoryArray = dir.getSubdirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
            Object[] $this$filter$iv = psiDirectoryArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiDirectory it = (PsiDirectory)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!this.isExcluded(project, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonExcludedChildren = (List)destination$iv$iv;
            if (nonExcludedChildren.size() != 1) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiDirectory)CollectionsKt.first((List)nonExcludedChildren)).getName(), (String)"getName(...)");
            Map $this$getOrPut$iv = dirGroups;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(childName);
            if (value$iv == null) {
                boolean bl3 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(childName, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((List)object2).add(dir);
        }
        Iterable iterable = dirGroups.entrySet();
        element$iv2 = iterable.iterator();
        if (!element$iv2.hasNext()) {
            object = null;
        } else {
            dir = element$iv2.next();
            if (!element$iv2.hasNext()) {
                object = dir;
            } else {
                Map.Entry it22 = (Map.Entry)dir;
                boolean bl4 = false;
                int it22 = ((List)it22.getValue()).size();
                do {
                    Object bl4 = element$iv2.next();
                    Map.Entry it32 = (Map.Entry)bl4;
                    boolean $i$a$-maxByOrNull-DirInsCommand$detectParallelSimpleDirs$largestGroup$2 = false;
                    int it32 = ((List)it32.getValue()).size();
                    if (it22 >= it32) continue;
                    dir = bl4;
                    it22 = it32;
                } while (element$iv2.hasNext());
                object = dir;
            }
        }
        Map.Entry largestGroup = (Map.Entry)object;
        if (largestGroup != null && ((List)largestGroup.getValue()).size() >= 2 && ((CharSequence)largestGroup.getKey()).length() > 0) {
            void $this$mapTo$iv$iv;
            String commonChildName = (String)largestGroup.getKey();
            Iterable $this$map$iv = (Iterable)largestGroup.getValue();
            boolean $i$f$map = false;
            Iterable it22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiDirectory answer$iv = (PsiDirectory)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            List parentDirNames = (List)destination$iv$iv;
            return new TreeNode.ParallelDirsNode("parallelDirs", parentDirNames, commonChildName);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCompressSubdirectories(Project project, PsiDirectory directory, List<? extends PsiDirectory> subdirectories, int depth) {
        boolean bl;
        if (depth <= this.defaultMaxDepth + 1) return false;
        if (subdirectories.size() <= 1) return false;
        Iterable $this$all$iv = subdirectories;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            void $this$filterTo$iv$iv;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            PsiDirectory subdir = (PsiDirectory)element$iv;
            boolean bl2 = false;
            PsiDirectory[] psiDirectoryArray = subdir.getSubdirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
            Object[] $this$filter$iv = psiDirectoryArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiDirectory it = (PsiDirectory)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!this.isExcluded(project, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List childDirs = (List)destination$iv$iv;
            if (!childDirs.isEmpty()) {
                boolean bl4;
                Iterable $this$all$iv2 = childDirs;
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        PsiDirectory it = (PsiDirectory)element$iv2;
                        boolean bl5 = false;
                        PsiDirectory[] psiDirectoryArray2 = it.getSubdirectories();
                        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray2, (String)"getSubdirectories(...)");
                        if (((Object[])psiDirectoryArray2).length != 0) return false;
                        boolean bl6 = true;
                        if (bl6) continue;
                        return false;
                    }
                    bl4 = true;
                }
                if (!bl4) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final List<PsiDirectory> getCompressableSubdirectories(List<? extends PsiDirectory> subdirectories) {
        return subdirectories;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTree(TreeNode node, int depth, StringBuilder output) {
        block9: {
            String indent = StringsKt.repeat((CharSequence)" ", (int)depth);
            if (!(node instanceof TreeNode.DirectoryNode)) break block9;
            Iterable $this$forEachIndexed$iv = ((TreeNode.DirectoryNode)node).getChildren();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                StringBuilder stringBuilder;
                void var16_16;
                void child;
                String prefix;
                block10: {
                    Object object;
                    block12: {
                        block11: {
                            int n;
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            TreeNode treeNode = (TreeNode)item$iv;
                            int index = n;
                            boolean bl = false;
                            boolean isLast = index == CollectionsKt.getLastIndex(((TreeNode.DirectoryNode)node).getChildren());
                            prefix = isLast ? "\u2514" : "\u251c";
                            var16_16 = child;
                            if (!(var16_16 instanceof TreeNode.FileNode)) break block10;
                            object = ((TreeNode.FileNode)child).getSize();
                            if (object == null) break block11;
                            String it = object;
                            boolean bl2 = false;
                            String string = " (" + it + ")";
                            object = string;
                            if (string != null) break block12;
                        }
                        object = "";
                    }
                    String sizeInfo = object;
                    StringBuilder stringBuilder2 = output.append(indent + prefix + "\u2500\u2500 " + ((TreeNode.FileNode)child).getName() + sizeInfo);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                    stringBuilder = stringBuilder3;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                    continue;
                }
                if (var16_16 instanceof TreeNode.DirectoryNode) {
                    StringBuilder stringBuilder4 = output.append(indent + prefix + "\u2500\u2500 " + ((TreeNode.DirectoryNode)child).getName() + "/");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                    this.renderTree((TreeNode)child, depth + 1, output);
                    stringBuilder = Unit.INSTANCE;
                    continue;
                }
                if (var16_16 instanceof TreeNode.CompressedNode) {
                    StringBuilder stringBuilder5 = output.append(indent + prefix + "\u2500\u2500 {" + CollectionsKt.joinToString$default((Iterable)((TreeNode.CompressedNode)child).getSubdirNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "}/");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                    StringBuilder stringBuilder6 = stringBuilder5.append('\n');
                    stringBuilder = stringBuilder6;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                    continue;
                }
                if (var16_16 instanceof TreeNode.ParallelDirsNode) {
                    String dirs = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((TreeNode.ParallelDirsNode)child).getDirNames()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                    StringBuilder stringBuilder7 = output.append(indent + prefix + "\u2500\u2500 {" + dirs + "}/" + ((TreeNode.ParallelDirsNode)child).getCommonChildName() + "/");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                    StringBuilder stringBuilder8 = stringBuilder7.append('\n');
                    stringBuilder = stringBuilder8;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean isExcluded(Project project, PsiDirectory directory) {
        boolean bl;
        Object[] objectArray = new String[]{".idea", "build", "target", ".gradle", "node_modules"};
        Set excludedDirs = SetsKt.setOf((Object[])objectArray);
        if (excludedDirs.contains(directory.getName())) {
            return true;
        }
        try {
            VirtualFile virtualFile = directory.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            bl = GitIgnoreUtil.INSTANCE.isIgnored(project, virtualFile);
        }
        catch (Exception e) {
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(directory.getVirtualFile());
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            bl = Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
        }
        return bl;
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final TreeNode.DirectoryNode executeDepth$lambda$0(DirInsCommand this$0, PsiDirectory $psiDirectory) {
        return this$0.buildDirectoryTree(this$0.myProject, $psiDirectory, 1);
    }

    public static final /* synthetic */ String access$getDir$p(DirInsCommand $this) {
        return $this.dir;
    }

    public static final /* synthetic */ StringBuilder access$getOutput$p(DirInsCommand $this) {
        return $this.output;
    }

    public static final /* synthetic */ void access$listDirectory(DirInsCommand $this, Project project, PsiDirectory directory, int depth) {
        $this.listDirectory(project, directory, depth);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "FileNode", "DirectoryNode", "CompressedNode", "ParallelDirsNode", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$CompressedNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$DirectoryNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$FileNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$ParallelDirsNode;", "devins-lang"})
    private static abstract class TreeNode {
        private TreeNode() {
        }

        @NotNull
        public abstract String getName();

        public /* synthetic */ TreeNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$CompressedNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode;", "name", "", "subdirNames", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getSubdirNames", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "devins-lang"})
        public static final class CompressedNode
        extends TreeNode {
            @NotNull
            private final String name;
            @NotNull
            private final List<String> subdirNames;

            public CompressedNode(@NotNull String name, @NotNull List<String> subdirNames) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(subdirNames, (String)"subdirNames");
                super(null);
                this.name = name;
                this.subdirNames = subdirNames;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final List<String> getSubdirNames() {
                return this.subdirNames;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final List<String> component2() {
                return this.subdirNames;
            }

            @NotNull
            public final CompressedNode copy(@NotNull String name, @NotNull List<String> subdirNames) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(subdirNames, (String)"subdirNames");
                return new CompressedNode(name, subdirNames);
            }

            public static /* synthetic */ CompressedNode copy$default(CompressedNode compressedNode, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = compressedNode.name;
                }
                if ((n & 2) != 0) {
                    list = compressedNode.subdirNames;
                }
                return compressedNode.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "CompressedNode(name=" + this.name + ", subdirNames=" + this.subdirNames + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + ((Object)this.subdirNames).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CompressedNode)) {
                    return false;
                }
                CompressedNode compressedNode = (CompressedNode)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)compressedNode.name)) {
                    return false;
                }
                return Intrinsics.areEqual(this.subdirNames, compressedNode.subdirNames);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$DirectoryNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode;", "name", "", "children", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getChildren", "()Ljava/util/List;", "addChild", "", "child", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "devins-lang"})
        public static final class DirectoryNode
        extends TreeNode {
            @NotNull
            private final String name;
            @NotNull
            private final List<TreeNode> children;

            public DirectoryNode(@NotNull String name, @NotNull List<TreeNode> children) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(children, (String)"children");
                super(null);
                this.name = name;
                this.children = children;
            }

            public /* synthetic */ DirectoryNode(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    list = new ArrayList();
                }
                this(string, list);
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final List<TreeNode> getChildren() {
                return this.children;
            }

            public final void addChild(@NotNull TreeNode child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                this.children.add(child);
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final List<TreeNode> component2() {
                return this.children;
            }

            @NotNull
            public final DirectoryNode copy(@NotNull String name, @NotNull List<TreeNode> children) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(children, (String)"children");
                return new DirectoryNode(name, children);
            }

            public static /* synthetic */ DirectoryNode copy$default(DirectoryNode directoryNode, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = directoryNode.name;
                }
                if ((n & 2) != 0) {
                    list = directoryNode.children;
                }
                return directoryNode.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "DirectoryNode(name=" + this.name + ", children=" + this.children + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + ((Object)this.children).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DirectoryNode)) {
                    return false;
                }
                DirectoryNode directoryNode = (DirectoryNode)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)directoryNode.name)) {
                    return false;
                }
                return Intrinsics.areEqual(this.children, directoryNode.children);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$FileNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode;", "name", "", "size", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getSize", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "devins-lang"})
        public static final class FileNode
        extends TreeNode {
            @NotNull
            private final String name;
            @Nullable
            private final String size;

            public FileNode(@NotNull String name, @Nullable String size) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                super(null);
                this.name = name;
                this.size = size;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Nullable
            public final String getSize() {
                return this.size;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @Nullable
            public final String component2() {
                return this.size;
            }

            @NotNull
            public final FileNode copy(@NotNull String name, @Nullable String size) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new FileNode(name, size);
            }

            public static /* synthetic */ FileNode copy$default(FileNode fileNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = fileNode.name;
                }
                if ((n & 2) != 0) {
                    string2 = fileNode.size;
                }
                return fileNode.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "FileNode(name=" + this.name + ", size=" + this.size + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + (this.size == null ? 0 : this.size.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FileNode)) {
                    return false;
                }
                FileNode fileNode = (FileNode)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)fileNode.name)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.size, (Object)fileNode.size);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode$ParallelDirsNode;", "Lcc/unitmesh/devti/language/compiler/exec/file/DirInsCommand$TreeNode;", "name", "", "dirNames", "", "commonChildName", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getDirNames", "()Ljava/util/List;", "getCommonChildName", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "devins-lang"})
        public static final class ParallelDirsNode
        extends TreeNode {
            @NotNull
            private final String name;
            @NotNull
            private final List<String> dirNames;
            @NotNull
            private final String commonChildName;

            public ParallelDirsNode(@NotNull String name, @NotNull List<String> dirNames, @NotNull String commonChildName) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(dirNames, (String)"dirNames");
                Intrinsics.checkNotNullParameter((Object)commonChildName, (String)"commonChildName");
                super(null);
                this.name = name;
                this.dirNames = dirNames;
                this.commonChildName = commonChildName;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final List<String> getDirNames() {
                return this.dirNames;
            }

            @NotNull
            public final String getCommonChildName() {
                return this.commonChildName;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final List<String> component2() {
                return this.dirNames;
            }

            @NotNull
            public final String component3() {
                return this.commonChildName;
            }

            @NotNull
            public final ParallelDirsNode copy(@NotNull String name, @NotNull List<String> dirNames, @NotNull String commonChildName) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(dirNames, (String)"dirNames");
                Intrinsics.checkNotNullParameter((Object)commonChildName, (String)"commonChildName");
                return new ParallelDirsNode(name, dirNames, commonChildName);
            }

            public static /* synthetic */ ParallelDirsNode copy$default(ParallelDirsNode parallelDirsNode, String string, List list, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = parallelDirsNode.name;
                }
                if ((n & 2) != 0) {
                    list = parallelDirsNode.dirNames;
                }
                if ((n & 4) != 0) {
                    string2 = parallelDirsNode.commonChildName;
                }
                return parallelDirsNode.copy(string, list, string2);
            }

            @NotNull
            public String toString() {
                return "ParallelDirsNode(name=" + this.name + ", dirNames=" + this.dirNames + ", commonChildName=" + this.commonChildName + ")";
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = result * 31 + ((Object)this.dirNames).hashCode();
                result = result * 31 + this.commonChildName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ParallelDirsNode)) {
                    return false;
                }
                ParallelDirsNode parallelDirsNode = (ParallelDirsNode)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)parallelDirsNode.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirNames, parallelDirsNode.dirNames)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.commonChildName, (Object)parallelDirsNode.commonChildName);
            }
        }
    }
}

