/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.claudeskill;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.command.dataprovider.ClaudeSkillCommand;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/claudeskill/ClaudeSkillInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "arguments", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isApplicable", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseSkillName", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nClaudeSkillInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeSkillInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/claudeskill/ClaudeSkillInsCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n11#2:100\n*S KotlinDebug\n*F\n+ 1 ClaudeSkillInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/claudeskill/ClaudeSkillInsCommand\n*L\n38#1:100\n*E\n"})
public final class ClaudeSkillInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @NotNull
    private final String arguments;
    @NotNull
    private final BuiltinCommand commandName;
    @NotNull
    private final Logger logger;

    public ClaudeSkillInsCommand(@NotNull Project project, @NotNull String prop, @NotNull String arguments) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.project = project;
        this.prop = prop;
        this.arguments = arguments;
        this.commandName = BuiltinCommand.CLAUDE_SKILL;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClaudeSkillInsCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    public boolean isApplicable() {
        return ClaudeSkillCommand.Companion.isAvailable(this.project);
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        String skillName = this.parseSkillName(this.prop);
        if (((CharSequence)skillName).length() == 0) {
            return DevInErrorKt.getDEVINS_ERROR() + " Invalid skill command format. Use /skill.<skillname> <arguments>";
        }
        ClaudeSkillCommand claudeSkill = ClaudeSkillCommand.Companion.fromSkillName(this.project, skillName);
        if (claudeSkill == null) {
            String availableSkills = CollectionsKt.joinToString$default((Iterable)ClaudeSkillCommand.Companion.all(this.project), (CharSequence)", ", null, null, (int)0, null, ClaudeSkillInsCommand::execute$lambda$0, (int)30, null);
            return DevInErrorKt.getDEVINS_ERROR() + " Skill not found: " + skillName + "\nAvailable skills: " + availableSkills;
        }
        try {
            String result = claudeSkill.executeWithCompiler(this.project, this.arguments, this.prop);
            VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
            return result;
        }
        catch (Exception e) {
            this.logger.error("Error executing Claude skill: " + skillName, (Throwable)e);
            return DevInErrorKt.getDEVINS_ERROR() + " Error executing skill." + skillName + ": " + e.getMessage();
        }
    }

    private final String parseSkillName(String prop) {
        String trimmed = ((Object)StringsKt.trim((CharSequence)prop)).toString();
        if (StringsKt.startsWith$default((String)trimmed, (String)"skill.", (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)trimmed, (CharSequence)"skill.");
        }
        if (StringsKt.startsWith$default((String)trimmed, (String)".", (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)trimmed, (CharSequence)".");
        }
        return trimmed;
    }

    private static final CharSequence execute$lambda$0(ClaudeSkillCommand it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSkillName();
    }
}

