/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.agents;

import cc.unitmesh.devti.a2a.A2AService;
import cc.unitmesh.devti.a2a.A2ASketchToolchainProvider;
import cc.unitmesh.devti.a2a.AgentRequest;
import cc.unitmesh.devti.agent.tool.AgentTool;
import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import cc.unitmesh.devti.language.compiler.exec.agents.AgentsInsCommand;
import cc.unitmesh.devti.provider.DevInsAgentToolCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0002J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J8\u0010\u0017\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050#2\u0006\u0010$\u001a\u00020\u0005H\u0002J \u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/agents/AgentsInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "codeContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "isApplicable", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listAllAgents", "appendUsageExamples", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendAgentInfo", "index", "", "name", "description", "scriptPath", "formatAgentExample", "agentName", "message", "parseRequest", "Lcc/unitmesh/devti/a2a/AgentRequest;", "parseCommand", "Lkotlin/Pair;", "input", "invokeAgent", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nAgentsInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentsInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/agents/AgentsInsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1864#2,3:244\n1864#2,3:247\n96#3:250\n11#4:251\n1#5:252\n*S KotlinDebug\n*F\n+ 1 AgentsInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/agents/AgentsInsCommand\n*L\n78#1:244,3\n85#1:247,3\n142#1:250\n144#1:251\n*E\n"})
public final class AgentsInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @NotNull
    private final String codeContent;
    @NotNull
    private final BuiltinCommand commandName;

    public AgentsInsCommand(@NotNull Project project, @NotNull String prop, @NotNull String codeContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)codeContent, (String)"codeContent");
        this.project = project;
        this.prop = prop;
        this.codeContent = codeContent;
        this.commandName = BuiltinCommand.AGENTS;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        if (StringsKt.isBlank((CharSequence)this.prop) && StringsKt.isBlank((CharSequence)this.codeContent)) {
            return this.listAllAgents();
        }
        AgentRequest agentRequest = this.parseRequest(this.prop, this.codeContent);
        if (agentRequest == null) {
            return DevInErrorKt.getDEVINS_ERROR() + " Invalid request format. Use JSON: {\"agent\": \"agent-name\", \"message\": \"your message\"}";
        }
        AgentRequest request2 = agentRequest;
        if (((CharSequence)request2.getAgent()).length() == 0) {
            return DevInErrorKt.getDEVINS_ERROR() + " Agent name is required.";
        }
        if (((CharSequence)request2.getMessage()).length() == 0) {
            return DevInErrorKt.getDEVINS_ERROR() + " Message is required.";
        }
        return this.invokeAgent(request2.getAgent(), request2.getMessage(), $completion);
    }

    private final String listAllAgents() {
        AgentTool agent;
        int index;
        int n;
        int index$iv;
        boolean $i$f$forEachIndexed;
        Iterable $this$forEachIndexed$iv;
        StringBuilder result = new StringBuilder();
        result.append("Available AI Agents:\n\n");
        List<AgentTool> a2aAgents = A2ASketchToolchainProvider.Companion.collectA2ATools(this.project);
        List<AgentTool> devInsAgents = DevInsAgentToolCollector.Companion.all(this.project);
        if (a2aAgents.isEmpty() && devInsAgents.isEmpty()) {
            result.append("No agents available. Please configure A2A agents or create DevIns agents.\n");
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        this.appendUsageExamples(result);
        if (!((Collection)a2aAgents).isEmpty()) {
            result.append("## A2A Agents\n\n");
            $this$forEachIndexed$iv = a2aAgents;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AgentTool agentTool = (AgentTool)item$iv;
                index = n;
                boolean bl = false;
                AgentsInsCommand.appendAgentInfo$default(this, result, index + 1, agent.getName(), agent.getDescription(), null, 16, null);
            }
        }
        if (!((Collection)devInsAgents).isEmpty()) {
            result.append("## DevIns Agents\n\n");
            $this$forEachIndexed$iv = devInsAgents;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                agent = (AgentTool)item$iv;
                index = n;
                boolean bl = false;
                String scriptPath = agent.getDevinScriptPath();
                this.appendAgentInfo(result, index + 1, agent.getName(), agent.getDescription(), scriptPath);
            }
        }
        result.append("---\n");
        result.append("Total: " + (a2aAgents.size() + devInsAgents.size()) + " agent(s) available\n");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendUsageExamples(StringBuilder result) {
        result.append("## Usage Examples\n\n");
        result.append("JSON format:\n");
        result.append(this.formatAgentExample("agent-name", "your message here"));
    }

    private final void appendAgentInfo(StringBuilder result, int index, String name, String description, String scriptPath) {
        CharSequence charSequence;
        result.append("### " + index + ". " + name + "\n");
        if (((CharSequence)description).length() > 0) {
            result.append("**Description**: " + description + "\n\n");
        }
        if (!((charSequence = (CharSequence)scriptPath) == null || charSequence.length() == 0)) {
            result.append("**Script**: " + scriptPath + "\n\n");
        }
        result.append("**Example**:\n");
        result.append(this.formatAgentExample(name, "Please help with this task"));
    }

    static /* synthetic */ void appendAgentInfo$default(AgentsInsCommand agentsInsCommand, StringBuilder stringBuilder, int n, String string, String string2, String string3, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        agentsInsCommand.appendAgentInfo(stringBuilder, n, string, string2, string3);
    }

    private final String formatAgentExample(String agentName, String message) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatAgentExample_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatAgentExample_u24lambda_u242.append("<devin>\n");
        $this$formatAgentExample_u24lambda_u242.append("/agents\n");
        $this$formatAgentExample_u24lambda_u242.append("```json\n");
        $this$formatAgentExample_u24lambda_u242.append("{\n");
        $this$formatAgentExample_u24lambda_u242.append("  \"agent\": \"" + agentName + "\",\n");
        $this$formatAgentExample_u24lambda_u242.append("  \"message\": \"" + message + "\"\n");
        $this$formatAgentExample_u24lambda_u242.append("}\n");
        $this$formatAgentExample_u24lambda_u242.append("```\n");
        $this$formatAgentExample_u24lambda_u242.append("</devin>\n\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final AgentRequest parseRequest(String prop, String codeContent) {
        if (!StringsKt.isBlank((CharSequence)codeContent)) {
            try {
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (AgentRequest)this_$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable(AgentRequest.Companion.serializer()), codeContent);
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(AgentsInsCommand.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to parse JSON request: " + e);
            }
        }
        Pair<String, String> pair = this.parseCommand(prop);
        String agentName = (String)pair.component1();
        String message = (String)pair.component2();
        return ((CharSequence)agentName).length() > 0 ? new AgentRequest(agentName, message) : null;
    }

    private final Pair<String, String> parseCommand(String input) {
        String trimmed = ((Object)StringsKt.trim((CharSequence)input)).toString();
        if (((CharSequence)trimmed).length() == 0) {
            return new Pair((Object)"", (Object)"");
        }
        Regex quotedMessageRegex = new Regex("^(\\S+)\\s+\"(.+)\"$");
        MatchResult quotedMatch = Regex.find$default((Regex)quotedMessageRegex, (CharSequence)trimmed, (int)0, (int)2, null);
        if (quotedMatch != null) {
            String agentName = (String)quotedMatch.getGroupValues().get(1);
            String message = (String)quotedMatch.getGroupValues().get(2);
            return new Pair((Object)agentName, (Object)message);
        }
        Regex singleQuotedRegex = new Regex("^(\\S+)\\s+'(.+)'$");
        MatchResult singleQuotedMatch = Regex.find$default((Regex)singleQuotedRegex, (CharSequence)trimmed, (int)0, (int)2, null);
        if (singleQuotedMatch != null) {
            String agentName = (String)singleQuotedMatch.getGroupValues().get(1);
            String message = (String)singleQuotedMatch.getGroupValues().get(2);
            return new Pair((Object)agentName, (Object)message);
        }
        String[] stringArray = new String[]{" "};
        List parts = StringsKt.split$default((CharSequence)trimmed, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        if (parts.size() >= 2) {
            return new Pair(parts.get(0), parts.get(1));
        }
        if (parts.size() == 1) {
            return new Pair(parts.get(0), (Object)"");
        }
        return new Pair((Object)"", (Object)"");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object invokeAgent(String var1_1, String var2_2, Continuation<? super String> $completion) {
        if (!($completion instanceof invokeAgent.1)) ** GOTO lbl-1000
        var14_4 = $completion;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AgentsInsCommand this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AgentsInsCommand.access$invokeAgent(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                a2aService = (A2AService)this.project.getService(A2AService.class);
                a2aService.initialize();
                if (!a2aService.isAvailable()) ** GOTO lbl36
                a2aAgents = A2ASketchToolchainProvider.Companion.collectA2ATools(this.project);
                var8_9 = a2aAgents;
                var9_11 = var8_9.iterator();
                while (var9_11.hasNext()) {
                    var10_12 = var9_11.next();
                    it = (AgentTool)var10_12;
                    $i$a$-find-AgentsInsCommand$invokeAgent$selectedAgent$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)agentName)) continue;
                    v0 = var10_12;
                    ** GOTO lbl26
                }
                v0 = null;
lbl26:
                // 2 sources

                selectedAgent = v0;
                if (selectedAgent != null) {
                    try {
                        response = a2aService.sendMessage(agentName, input);
                        if (response != null) {
                            return "A2A Agent '" + agentName + "' response:\n" + response;
                        }
                    }
                    catch (Exception e) {
                        return DevInErrorKt.getDEVINS_ERROR() + " Error invoking A2A agent '" + agentName + "': " + e.getMessage();
                    }
                }
lbl36:
                // 4 sources

                devInsAgents = DevInsAgentToolCollector.Companion.all(this.project);
                var8_9 = devInsAgents;
                var9_11 = var8_9.iterator();
                while (var9_11.hasNext()) {
                    var10_12 = var9_11.next();
                    it = (AgentTool)var10_12;
                    $i$a$-find-AgentsInsCommand$invokeAgent$devInsAgent$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)agentName)) continue;
                    v1 = var10_12;
                    ** GOTO lbl47
                }
                v1 = null;
lbl47:
                // 2 sources

                devInsAgent = v1;
                if (devInsAgent == null) {
                    return DevInErrorKt.getDEVINS_ERROR() + " Agent '" + agentName + "' not found. Use /agents to list all available agents.";
                }
                try {
                    collectors = ExtensionPointName.Companion.create("cc.unitmesh.devInsAgentTool").getExtensionList();
                    var8_9 = collectors.iterator();
                }
                catch (Exception e) {
                    return DevInErrorKt.getDEVINS_ERROR() + " Error executing DevIns agent '" + agentName + "': " + e.getMessage();
                }
                while (true) {
                    if (var8_9.hasNext() == false) return DevInErrorKt.getDEVINS_ERROR() + " Failed to execute DevIns agent '" + agentName + "'";
                    collector = (DevInsAgentToolCollector)var8_9.next();
                    $continuation.L$0 = agentName;
                    $continuation.L$1 = input;
                    $continuation.L$2 = var8_9;
                    $continuation.label = 1;
                    v2 = collector.execute(this.project, agentName, input, (Continuation<? super String>)$continuation);
                    if (v2 != var15_6) continue;
                    return var15_6;
                }
            }
            case 1: {
                var8_9 = (Iterator)$continuation.L$2;
                input = (String)$continuation.L$1;
                agentName = (String)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    if ((result = (String)v2) == null) ** continue;
                    return "DevIns Agent '" + agentName + "' response:\n" + result;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$invokeAgent(AgentsInsCommand $this, String agentName, String input, Continuation $completion) {
        return $this.invokeAgent(agentName, input, (Continuation<? super String>)$completion);
    }
}

