/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec.agents;

import cc.unitmesh.devti.a2a.A2AService;
import cc.unitmesh.devti.a2a.AgentRequest;
import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/agents/A2AInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "project", "Lcom/intellij/openapi/project/Project;", "prop", "", "codeContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "isApplicable", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseRequest", "Lcc/unitmesh/devti/a2a/AgentRequest;", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nA2AInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2AInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/agents/A2AInsCommand\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n96#2:85\n11#3:86\n*S KotlinDebug\n*F\n+ 1 A2AInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/agents/A2AInsCommand\n*L\n76#1:85\n78#1:86\n*E\n"})
public final class A2AInsCommand
implements InsCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final String prop;
    @NotNull
    private final String codeContent;
    @NotNull
    private final BuiltinCommand commandName;

    public A2AInsCommand(@NotNull Project project, @NotNull String prop, @NotNull String codeContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)codeContent, (String)"codeContent");
        this.project = project;
        this.prop = prop;
        this.codeContent = codeContent;
        this.commandName = BuiltinCommand.A2A;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    public boolean isApplicable() {
        A2AService a2aService = (A2AService)this.project.getService(A2AService.class);
        return a2aService.isAvailable();
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        String string;
        A2AService a2aService = (A2AService)this.project.getService(A2AService.class);
        a2aService.initialize();
        if (!a2aService.isAvailable()) {
            return "A2A service is not available. Please check your A2A configuration.";
        }
        AgentRequest request2 = this.parseRequest(this.prop, this.codeContent);
        if (request2 == null) {
            return DevInErrorKt.getDEVINS_ERROR() + " Invalid request format. Use JSON: {\"agent\": \"code-reviewer\", \"message\": \"review this\"} or legacy format: agent-name \"message\"";
        }
        if (((CharSequence)request2.getAgent()).length() == 0) {
            return DevInErrorKt.getDEVINS_ERROR() + " Agent name is required.";
        }
        if (((CharSequence)request2.getMessage()).length() == 0) {
            return DevInErrorKt.getDEVINS_ERROR() + " Message is required.";
        }
        try {
            String response = a2aService.sendMessage(request2.getAgent(), request2.getMessage());
            string = response != null ? "A2A Agent '" + request2.getAgent() + "' response:\n" + response : DevInErrorKt.getDEVINS_ERROR() + " Failed to get response from agent '" + request2.getAgent() + "'";
        }
        catch (Exception e) {
            string = DevInErrorKt.getDEVINS_ERROR() + " Error communicating with agent '" + request2.getAgent() + "': " + e.getMessage();
        }
        return string;
    }

    @Nullable
    public final AgentRequest parseRequest(@NotNull String prop, @NotNull String codeContent) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)codeContent, (String)"codeContent");
        if (!StringsKt.isBlank((CharSequence)codeContent)) {
            try {
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (AgentRequest)this_$iv.decodeFromString((DeserializationStrategy)AgentRequest.Companion.serializer(), codeContent);
            }
            catch (SerializationException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(A2AInsCommand.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to parse JSON request: " + e);
            }
        }
        return null;
    }
}

