/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec;

import cc.unitmesh.devti.agent.tool.search.RipgrepSearcher;
import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/RipgrepSearchInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "scope", "", "text", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getText", "()Ljava/lang/String;", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "isApplicable", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "devins-lang"})
public final class RipgrepSearchInsCommand
implements InsCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String scope;
    @Nullable
    private final String text;
    @NotNull
    private final BuiltinCommand commandName;

    public RipgrepSearchInsCommand(@NotNull Project myProject, @NotNull String scope, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.myProject = myProject;
        this.scope = scope;
        this.text = text;
        this.commandName = BuiltinCommand.RIPGREP_SEARCH;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    public boolean isApplicable() {
        boolean bl;
        try {
            bl = RipgrepSearcher.INSTANCE.findRipgrepBinary() != null;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        String result;
        VirtualFile virtualFile = this.myProject.getBaseDir();
        Intrinsics.checkNotNull((Object)virtualFile);
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String searchDirectory = string;
        String string2 = this.text;
        if (string2 == null) {
            string2 = this.scope;
        }
        String searchContent = string2;
        String string3 = result = RipgrepSearcher.INSTANCE.searchFiles(this.myProject, searchDirectory, searchContent, null).get();
        return (string3 != null ? ((CharSequence)string3).length() > 0 : false) ? "RipGrep Search Result (" + searchContent + "): \n===============================\n" + result + "\n===============================\n" : "No result found for /" + this.getCommandName() + ":" + searchContent;
    }
}

