/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.language.compiler.error.DevInErrorKt;
import cc.unitmesh.devti.language.compiler.exec.file.WriteInsCommandKt;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/PatchInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "prop", "", "codeContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getProp", "()Ljava/lang/String;", "getCodeContent", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parsePatches", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "content", "shouldShowParseErrorNotification", "", "Companion", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nPatchInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/PatchInsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1855#2,2:103\n*S KotlinDebug\n*F\n+ 1 PatchInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/PatchInsCommand\n*L\n42#1:103,2\n*E\n"})
public final class PatchInsCommand
implements InsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String prop;
    @NotNull
    private final String codeContent;
    @NotNull
    private final BuiltinCommand commandName;
    private static final int MAX_ERRORS_IN_WINDOW = 3;
    private static final long ERROR_TIME_WINDOW_MS = 60000L;
    private static int parseErrorCount;
    private static long lastErrorTime;

    public PatchInsCommand(@NotNull Project myProject, @NotNull String prop, @NotNull String codeContent) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        Intrinsics.checkNotNullParameter((Object)codeContent, (String)"codeContent");
        this.myProject = myProject;
        this.prop = prop;
        this.codeContent = codeContent;
        this.commandName = BuiltinCommand.PATCH;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public final String getProp() {
        return this.prop;
    }

    @NotNull
    public final String getCodeContent() {
        return this.codeContent;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        List<TextFilePatch> filePatches = this.parsePatches(this.codeContent);
        if (filePatches == null) {
            boolean shouldShowNotification = this.shouldShowParseErrorNotification();
            if (shouldShowNotification) {
                AutoDevNotifications.INSTANCE.warn(this.myProject, "Failed to parse patches from content");
            }
            return DevInErrorKt.getDEVINS_ERROR() + ": Failed to parse patches";
        }
        if (filePatches.isEmpty()) {
            AutoDevNotifications.INSTANCE.warn(this.myProject, "No patches found in content");
            return DevInErrorKt.getDEVINS_ERROR() + ": No patches found";
        }
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        CheckedDisposable disposable = checkedDisposable;
        Ref.ObjectRef result = new Ref.ObjectRef();
        WriteInsCommandKt.runInEdtAsync(disposable, (Function0<Unit>)((Function0)() -> PatchInsCommand.execute$lambda$1(filePatches, result, this)));
        if (AutoSketchMode.Companion.getInstance(this.myProject).isEnable()) {
            result.element = "";
        }
        return result.element;
    }

    private final List<TextFilePatch> parsePatches(String content) {
        Object object;
        try {
            PatchReader $this$parsePatches_u24lambda_u242 = object = new PatchReader((CharSequence)content);
            boolean bl = false;
            $this$parsePatches_u24lambda_u242.parseAllPatches();
            object = object.getTextPatches();
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private final boolean shouldShowParseErrorNotification() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastErrorTime > 60000L) {
            parseErrorCount = 0;
            lastErrorTime = currentTime;
        }
        int n = parseErrorCount;
        parseErrorCount = n + 1;
        return parseErrorCount <= 3;
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final Unit execute$lambda$1(List $filePatches, Ref.ObjectRef $result, PatchInsCommand this$0) {
        Iterable $this$forEach$iv = $filePatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenericPatchApplier.AppliedPatch appliedPatch;
            GenericPatchApplier.AppliedPatch appliedPatch2;
            TextFilePatch it = (TextFilePatch)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this$0.myProject);
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile vfile = virtualFile.findFileByRelativePath(it.getBeforeName().toString());
            if (vfile == null) {
                $result.element = $result.element + DevInErrorKt.getDEVINS_ERROR() + ": File not found: " + it.getBeforeName();
                return Unit.INSTANCE;
            }
            try {
                appliedPatch2 = GenericPatchApplier.apply((CharSequence)SingleFileDiffSketchKt.readText(vfile), (List)it.getHunks());
            }
            catch (Exception e) {
                $result.element = $result.element + DevInErrorKt.getDEVINS_ERROR() + ": Failed to apply patch: " + it.getBeforeName() + ", " + e.getMessage();
                appliedPatch2 = null;
            }
            if (appliedPatch2 == null) {
                return Unit.INSTANCE;
            }
            if (appliedPatch.status != ApplyPatchStatus.SUCCESS && appliedPatch.status != ApplyPatchStatus.PARTIAL) continue;
            String string = appliedPatch.patchedText;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"patchedText");
            SingleFileDiffSketchKt.writeText(vfile, string);
            $result.element = $result.element + "Patch applied successfully: " + it.getBeforeName() + "\n";
        }
        Object cfr_ignored_0 = $result.element;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/PatchInsCommand$Companion;", "", "<init>", "()V", "MAX_ERRORS_IN_WINDOW", "", "ERROR_TIME_WINDOW_MS", "", "parseErrorCount", "lastErrorTime", "devins-lang"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

