/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.compiler.exec;

import cc.unitmesh.devti.command.InsCommand;
import cc.unitmesh.devti.command.dataprovider.BuiltinCommand;
import cc.unitmesh.devti.context.FileContext;
import cc.unitmesh.devti.context.FileContextProvider;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInputKt;
import cc.unitmesh.devti.language.utils.ProjectFileUtilKt;
import cc.unitmesh.devti.vcs.gitignore.GitIgnoreUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/language/compiler/exec/LocalSearchInsCommand;", "Lcc/unitmesh/devti/command/InsCommand;", "myProject", "Lcom/intellij/openapi/project/Project;", "scope", "", "text", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getText", "()Ljava/lang/String;", "commandName", "Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "getCommandName", "()Lcc/unitmesh/devti/command/dataprovider/BuiltinCommand;", "MAX_LINE_SIZE", "", "OVERLAP", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectAdditionalFileInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "search", "", "", "project", "keyword", "overlap", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nLocalSearchInsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalSearchInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/LocalSearchInsCommand\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n125#2:118\n152#2,3:119\n766#3:122\n857#3,2:123\n1549#3:125\n1620#3,3:126\n1360#3:129\n1446#3,2:130\n1559#3:132\n1590#3,4:133\n1448#3,3:137\n*S KotlinDebug\n*F\n+ 1 LocalSearchInsCommand.kt\ncc/unitmesh/devti/language/compiler/exec/LocalSearchInsCommand\n*L\n41#1:118\n41#1:119,3\n96#1:122\n96#1:123,2\n99#1:125\n99#1:126,3\n102#1:129\n102#1:130,2\n105#1:132\n105#1:133,4\n102#1:137,3\n*E\n"})
public final class LocalSearchInsCommand
implements InsCommand {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String scope;
    @Nullable
    private final String text;
    @NotNull
    private final BuiltinCommand commandName;
    private final int MAX_LINE_SIZE;
    private final int OVERLAP;

    public LocalSearchInsCommand(@NotNull Project myProject, @NotNull String scope, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.myProject = myProject;
        this.scope = scope;
        this.text = text;
        this.commandName = BuiltinCommand.LOCAL_SEARCH;
        this.MAX_LINE_SIZE = 180;
        this.OVERLAP = 4;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public BuiltinCommand getCommandName() {
        return this.commandName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object execute(@NotNull Continuation<? super String> $completion) {
        void $this$mapTo$iv$iv;
        Map textSearch;
        String text;
        String string = this.text;
        if (string == null) {
            string = this.scope;
        }
        if ((text = ((Object)StringsKt.trim((CharSequence)string)).toString()).length() <= 3) {
            throw new IllegalArgumentException("Text length should be more than 4");
        }
        Map $this$map$iv = textSearch = (Map)ActionsKt.runReadAction(() -> LocalSearchInsCommand.execute$lambda$0(this, text));
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile file = (VirtualFile)entry.getKey();
            List lines = (List)entry.getValue();
            String fileInfo = (String)ActionsKt.runReadAction(() -> LocalSearchInsCommand.execute$lambda$2$lambda$1(this, file));
            String filePath = AutoDevInputKt.relativePath(file, this.myProject);
            String linesWithContext = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            collection.add("file: " + filePath + "\n" + fileInfo + "\n" + linesWithContext);
        }
        String results2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (((CharSequence)results2).length() == 0) {
            return "No result found for /" + this.getCommandName() + ":" + text;
        }
        return results2;
    }

    private final String collectAdditionalFileInfo(VirtualFile file) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        FileContext fileContext = new FileContextProvider().from(psiFile3);
        if (fileContext == null) {
            return null;
        }
        FileContext fileContext2 = fileContext;
        if (fileContext2.getClasses().isEmpty()) {
            return null;
        }
        return "```plantuml\n" + fileContext2.formatClass() + "\n```";
    }

    private final Map<VirtualFile, List<String>> search(Project project, String keyword, int overlap) {
        Map result = new LinkedHashMap();
        ProjectFileIndex.getInstance((Project)project).iterateContent(arg_0 -> LocalSearchInsCommand.search$lambda$7(project, result, this, keyword, overlap, arg_0));
        return result;
    }

    static /* synthetic */ Map search$default(LocalSearchInsCommand localSearchInsCommand, Project project, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = localSearchInsCommand.OVERLAP;
        }
        return localSearchInsCommand.search(project, string, n);
    }

    @Override
    public boolean isApplicable() {
        return InsCommand.DefaultImpls.isApplicable(this);
    }

    private static final Map execute$lambda$0(LocalSearchInsCommand this$0, String $text) {
        return this$0.search(this$0.myProject, $text, this$0.OVERLAP);
    }

    private static final String execute$lambda$2$lambda$1(LocalSearchInsCommand this$0, VirtualFile $file) {
        return this$0.collectAdditionalFileInfo($file);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean search$lambda$7(Project $project, Map $result, LocalSearchInsCommand this$0, String $keyword, int $overlap, VirtualFile file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IndexedValue indexedValue;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!ProjectFileUtilKt.canBeAdded(file) || !ProjectFileIndex.getInstance((Project)$project).isInContent(file)) {
            return true;
        }
        try {
            bl = GitIgnoreUtil.INSTANCE.isIgnored($project, file);
        }
        catch (Exception e) {
            bl = ProjectFileIndex.getInstance((Project)$project).isUnderIgnored(file);
        }
        boolean isIgnored = bl;
        if (isIgnored) {
            return true;
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)".idea", (boolean)false, (int)2, null)) {
            return true;
        }
        byte[] byArray = file.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        byte[] e = byArray;
        Object object = Charsets.UTF_8;
        List content = StringsKt.lines((CharSequence)new String(e, (Charset)object));
        object = CollectionsKt.withIndex((Iterable)content);
        boolean $i$f$filter = false;
        void var11_14 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            indexedValue = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            String line = (String)indexedValue.component2();
            if (!(line.length() < this$0.MAX_LINE_SIZE && StringsKt.contains$default((CharSequence)line, (CharSequence)$keyword, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getIndex());
        }
        List matchedIndices = (List)destination$iv$iv;
        if (!((Collection)matchedIndices).isEmpty()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = matchedIndices;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapIndexedTo$iv$iv;
                int index = ((Number)element$iv$iv).intValue();
                boolean bl4 = false;
                int start2 = RangesKt.coerceAtLeast((int)(index - $overlap), (int)0);
                int end = RangesKt.coerceAtMost((int)(index + $overlap), (int)(content.size() - 1));
                Iterable $this$mapIndexed$iv = content.subList(start2, end + 1);
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void line;
                    void offset;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string2 = (String)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv3;
                    boolean bl5 = false;
                    collection.add(start2 + offset + 1 + " " + (String)line);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List linesWithContext = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
            $result.put(file, linesWithContext);
        }
        return true;
    }
}

